/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public final class AArch64Address
extends AbstractAddress {
    public static final AArch64Address PLACEHOLDER = AArch64Address.createPcLiteralAddress(0);
    private final Register base;
    private final Register offset;
    private final int immediate;
    private final boolean registerOffsetScaled;
    private final AArch64Assembler.ExtendType extendType;
    private final AddressingMode addressingMode;

    public static AArch64Address createAddress(AddressingMode addressingMode, Register base, Register offset, int immediate, boolean isScaled, AArch64Assembler.ExtendType extendType) {
        return new AArch64Address(base, offset, immediate, isScaled, extendType, addressingMode);
    }

    private static boolean isValidSize(int size, AddressingMode mode) {
        switch (mode) {
            case IMMEDIATE_SIGNED_UNSCALED: 
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: 
            case IMMEDIATE_UNSIGNED_SCALED: {
                return size == 8 || size == 16 || size == 32 || size == 64 || size == 128;
            }
            case IMMEDIATE_PAIR_SIGNED_SCALED: 
            case IMMEDIATE_PAIR_POST_INDEXED: 
            case IMMEDIATE_PAIR_PRE_INDEXED: {
                return size == 32 || size == 64 || size == 128;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private static boolean immediateFitsInInstruction(AddressingMode mode, int immediate) {
        switch (mode) {
            case IMMEDIATE_SIGNED_UNSCALED: 
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: {
                return NumUtil.isSignedNbit(9, immediate);
            }
            case IMMEDIATE_UNSIGNED_SCALED: {
                return NumUtil.isUnsignedNbit(12, immediate);
            }
            case IMMEDIATE_PAIR_SIGNED_SCALED: 
            case IMMEDIATE_PAIR_POST_INDEXED: 
            case IMMEDIATE_PAIR_PRE_INDEXED: {
                return NumUtil.isSignedNbit(7, immediate);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public static boolean isImmediateScaled(AddressingMode mode) {
        switch (mode) {
            case IMMEDIATE_UNSIGNED_SCALED: 
            case IMMEDIATE_PAIR_SIGNED_SCALED: 
            case IMMEDIATE_PAIR_POST_INDEXED: 
            case IMMEDIATE_PAIR_PRE_INDEXED: {
                return true;
            }
        }
        return false;
    }

    private static int getScaledImmediate(int size, int immediate) {
        int byteSize = size / 8;
        int mask = byteSize - 1;
        if (mask != 0 && (immediate & mask) != 0) {
            return Integer.MAX_VALUE;
        }
        return immediate / byteSize;
    }

    public static AArch64Address createImmediateAddress(int size, AddressingMode addressingMode, Register base, int immediate) {
        GraalError.guarantee(AArch64Address.isValidImmediateAddress(size, addressingMode, immediate), "provided immediate cannot be encoded in instruction");
        boolean isScaled = AArch64Address.isImmediateScaled(addressingMode);
        int absoluteImm = immediate;
        if (isScaled) {
            absoluteImm = AArch64Address.getScaledImmediate(size, immediate);
        }
        return new AArch64Address(base, AArch64.zr, absoluteImm, false, null, addressingMode);
    }

    public static boolean isValidImmediateAddress(int size, AddressingMode addressingMode, int immediate) {
        assert (AArch64Address.isValidSize(size, addressingMode)) : "invalid transfer size";
        int absoluteImm = immediate;
        if (AArch64Address.isImmediateScaled(addressingMode) && (absoluteImm = AArch64Address.getScaledImmediate(size, immediate)) == Integer.MAX_VALUE) {
            return false;
        }
        return AArch64Address.immediateFitsInInstruction(addressingMode, absoluteImm);
    }

    public static AArch64Address createBaseRegisterOnlyAddress(Register base) {
        return AArch64Address.createRegisterOffsetAddress(base, AArch64.zr, false);
    }

    public static AArch64Address createRegisterOffsetAddress(Register base, Register offset, boolean scaled) {
        return new AArch64Address(base, offset, 0, scaled, null, AddressingMode.REGISTER_OFFSET);
    }

    public static AArch64Address createExtendedRegisterOffsetAddress(Register base, Register offset, boolean scaled, AArch64Assembler.ExtendType extendType) {
        return new AArch64Address(base, offset, 0, scaled, extendType, AddressingMode.EXTENDED_REGISTER_OFFSET);
    }

    public static AArch64Address createPcLiteralAddress(int imm21) {
        return new AArch64Address(AArch64.zr, AArch64.zr, imm21, false, null, AddressingMode.PC_LITERAL);
    }

    private AArch64Address(Register base, Register offset, int immediate, boolean registerOffsetScaled, AArch64Assembler.ExtendType extendType, AddressingMode addressingMode) {
        this.base = base;
        this.offset = offset;
        this.addressingMode = (addressingMode == AddressingMode.REGISTER_OFFSET || addressingMode == AddressingMode.EXTENDED_REGISTER_OFFSET) && offset.equals((Object)AArch64.zr) ? AddressingMode.BASE_REGISTER_ONLY : addressingMode;
        this.immediate = immediate;
        this.registerOffsetScaled = registerOffsetScaled;
        this.extendType = extendType;
        assert (this.verify());
    }

    private boolean verify() {
        assert (this.addressingMode != null);
        assert (this.base.getRegisterCategory().equals((Object)AArch64.CPU));
        assert (this.offset.getRegisterCategory().equals((Object)AArch64.CPU));
        switch (this.addressingMode) {
            case IMMEDIATE_UNSIGNED_SCALED: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isUnsignedNbit(12, this.immediate));
                break;
            }
            case IMMEDIATE_SIGNED_UNSCALED: 
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(9, this.immediate));
                break;
            }
            case BASE_REGISTER_ONLY: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (this.immediate == 0);
                break;
            }
            case REGISTER_OFFSET: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.getRegisterCategory().equals((Object)AArch64.CPU));
                assert (this.extendType == null);
                assert (this.immediate == 0);
                break;
            }
            case EXTENDED_REGISTER_OFFSET: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.getRegisterCategory().equals((Object)AArch64.CPU));
                assert (this.extendType == AArch64Assembler.ExtendType.SXTW || this.extendType == AArch64Assembler.ExtendType.UXTW);
                assert (this.immediate == 0);
                break;
            }
            case PC_LITERAL: {
                assert (this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(21, this.immediate));
                assert ((this.immediate & 3) == 0);
                break;
            }
            case IMMEDIATE_PAIR_SIGNED_SCALED: 
            case IMMEDIATE_PAIR_POST_INDEXED: 
            case IMMEDIATE_PAIR_PRE_INDEXED: {
                assert (!this.base.equals((Object)AArch64.zr));
                assert (this.offset.equals((Object)AArch64.zr));
                assert (this.extendType == null);
                assert (NumUtil.isSignedNbit(7, this.immediate));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return true;
    }

    public Register getBase() {
        return this.base;
    }

    public Register getOffset() {
        return this.offset;
    }

    public int getImmediate() {
        switch (this.addressingMode) {
            case IMMEDIATE_SIGNED_UNSCALED: 
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: {
                assert (NumUtil.isSignedNbit(9, this.immediate));
                return this.immediate & NumUtil.getNbitNumberInt(9);
            }
            case IMMEDIATE_UNSIGNED_SCALED: {
                assert (NumUtil.isUnsignedNbit(12, this.immediate));
                return this.immediate;
            }
            case IMMEDIATE_PAIR_SIGNED_SCALED: 
            case IMMEDIATE_PAIR_POST_INDEXED: 
            case IMMEDIATE_PAIR_PRE_INDEXED: {
                assert (NumUtil.isSignedNbit(7, this.immediate));
                return this.immediate & NumUtil.getNbitNumberInt(7);
            }
            case PC_LITERAL: {
                assert (NumUtil.isSignedNbit(19, this.immediate >> 2));
                return this.immediate >> 2 & NumUtil.getNbitNumberInt(19);
            }
        }
        throw GraalError.shouldNotReachHere("Should only be called for addressing modes that use immediate values.");
    }

    public int getImmediateRaw() {
        switch (this.addressingMode) {
            case IMMEDIATE_SIGNED_UNSCALED: 
            case IMMEDIATE_POST_INDEXED: 
            case IMMEDIATE_PRE_INDEXED: 
            case IMMEDIATE_UNSIGNED_SCALED: 
            case IMMEDIATE_PAIR_SIGNED_SCALED: 
            case IMMEDIATE_PAIR_POST_INDEXED: 
            case IMMEDIATE_PAIR_PRE_INDEXED: 
            case PC_LITERAL: {
                return this.immediate;
            }
        }
        throw GraalError.shouldNotReachHere("Should only be called for addressing modes that use immediate values.");
    }

    public boolean isRegisterOffsetScaled() {
        return this.registerOffsetScaled;
    }

    public AArch64Assembler.ExtendType getExtendType() {
        return this.extendType;
    }

    public AddressingMode getAddressingMode() {
        return this.addressingMode;
    }

    public String toString(int log2TransferSize) {
        int regShiftVal = this.registerOffsetScaled ? log2TransferSize : 0;
        switch (this.addressingMode) {
            case IMMEDIATE_UNSIGNED_SCALED: 
            case IMMEDIATE_PAIR_SIGNED_SCALED: {
                return String.format("[X%d, %d]", this.base.encoding, this.immediate << log2TransferSize);
            }
            case IMMEDIATE_SIGNED_UNSCALED: {
                return String.format("[X%d, %d]", this.base.encoding, this.immediate);
            }
            case BASE_REGISTER_ONLY: {
                return String.format("[X%d]", this.base.encoding);
            }
            case EXTENDED_REGISTER_OFFSET: {
                if (regShiftVal != 0) {
                    return String.format("[X%d, W%d, %s %d]", this.base.encoding, this.offset.encoding, this.extendType.name(), regShiftVal);
                }
                return String.format("[X%d, W%d, %s]", this.base.encoding, this.offset.encoding, this.extendType.name());
            }
            case REGISTER_OFFSET: {
                if (regShiftVal != 0) {
                    return String.format("[X%d, X%d, LSL %d]", this.base.encoding, this.offset.encoding, regShiftVal);
                }
                return String.format("[X%d, X%d]", this.base.encoding, this.offset.encoding);
            }
            case PC_LITERAL: {
                return String.format(".%s%d", this.immediate >= 0 ? "+" : "", this.immediate);
            }
            case IMMEDIATE_POST_INDEXED: {
                return String.format("[X%d],%d", this.base.encoding, this.immediate);
            }
            case IMMEDIATE_PRE_INDEXED: {
                return String.format("[X%d,%d]!", this.base.encoding, this.immediate);
            }
            case IMMEDIATE_PAIR_POST_INDEXED: {
                return String.format("[X%d],%d", this.base.encoding, this.immediate << log2TransferSize);
            }
            case IMMEDIATE_PAIR_PRE_INDEXED: {
                return String.format("[X%d,%d]!", this.base.encoding, this.immediate << log2TransferSize);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public static enum AddressingMode {
        IMMEDIATE_UNSIGNED_SCALED,
        IMMEDIATE_SIGNED_UNSCALED,
        BASE_REGISTER_ONLY,
        REGISTER_OFFSET,
        EXTENDED_REGISTER_OFFSET,
        PC_LITERAL,
        IMMEDIATE_POST_INDEXED,
        IMMEDIATE_PRE_INDEXED,
        IMMEDIATE_PAIR_SIGNED_SCALED,
        IMMEDIATE_PAIR_POST_INDEXED,
        IMMEDIATE_PAIR_PRE_INDEXED;

    }
}

