/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.aarch64;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.debug.GraalError;

public abstract class AArch64ASIMDAssembler {
    private static final int UBit = 0x20000000;
    private final AArch64Assembler asm;
    private static final int ASIMDSizeOffset = 22;
    private static final int elemSize00 = 0;
    private static final int elemSize01 = 0x400000;
    private static final int elemSize10 = 0x800000;
    private static final int elemSize11 = 0xC00000;

    protected AArch64ASIMDAssembler(AArch64Assembler asm) {
        this.asm = asm;
    }

    protected void emitInt(int x) {
        this.asm.emitInt(x);
    }

    private static boolean usesMultipleLanes(ASIMDSize size, ElementSize eSize) {
        return size != ASIMDSize.HalfReg || eSize != ElementSize.DoubleWord;
    }

    private static int elemSizeXX(ElementSize eSize) {
        return eSize.encoding << 22;
    }

    private static int elemSize1X(ElementSize eSize) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        return (2 | (eSize == ElementSize.DoubleWord ? 1 : 0)) << 22;
    }

    private static int elemSize0X(ElementSize eSize) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        return (eSize == ElementSize.DoubleWord ? 1 : 0) << 22;
    }

    private static int qBit(boolean isSet) {
        return (isSet ? 1 : 0) << 30;
    }

    private static int qBit(ASIMDSize size) {
        return (size == ASIMDSize.FullReg ? 1 : 0) << 30;
    }

    private void scalarThreeSameEncoding(ASIMDInstruction instr, int eSizeEncoding, Register dst, Register src1, Register src2) {
        int baseEncoding = 1579156480;
        this.emitInt(instr.encoding | baseEncoding | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void copyEncoding(ASIMDInstruction instr, boolean setQBit, ElementSize eSize, Register dst, Register src, int index) {
        assert (index >= 0 && index < ASIMDSize.FullReg.bytes() / eSize.bytes());
        int baseEncoding = 0xE000400;
        int imm5Encoding = (index * 2 * eSize.bytes() | eSize.bytes()) << 16;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(setQBit) | imm5Encoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    private void twoRegMiscEncoding(ASIMDInstruction instr, ASIMDSize size, int eSizeEncoding, Register dst, Register src) {
        this.twoRegMiscEncoding(instr, size == ASIMDSize.FullReg, eSizeEncoding, dst, src);
    }

    private void twoRegMiscEncoding(ASIMDInstruction instr, boolean setQBit, int eSizeEncoding, Register dst, Register src) {
        int baseEncoding = 236980224;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(setQBit) | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    private void acrossLanesEncoding(ASIMDInstruction instr, ASIMDSize size, int eSizeEncoding, Register dst, Register src) {
        int baseEncoding = 238028800;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    public void threeDifferentEncoding(ASIMDInstruction instr, boolean setQBit, int eSizeEncoding, Register dst, Register src1, Register src2) {
        int baseEncoding = 0xE200000;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(setQBit) | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    private void threeSameEncoding(ASIMDInstruction instr, ASIMDSize size, int eSizeEncoding, Register dst, Register src1, Register src2) {
        int baseEncoding = 236979200;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | eSizeEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void modifiedImmEncoding(ImmediateOp op, ASIMDSize size, Register dst, long imm) {
        int baseEncoding = 0xF000400;
        int immEncoding = ASIMDImmediateTable.getEncoding(imm, op);
        this.emitInt(baseEncoding | AArch64ASIMDAssembler.qBit(size) | immEncoding | AArch64Assembler.rd(dst));
    }

    public void shiftByImmEncoding(ASIMDInstruction instr, ASIMDSize size, int imm7, Register dst, Register src) {
        this.shiftByImmEncoding(instr, size == ASIMDSize.FullReg, imm7, dst, src);
    }

    public void shiftByImmEncoding(ASIMDInstruction instr, boolean setQBit, int imm7, Register dst, Register src) {
        assert ((imm7 & 0x7F) == imm7);
        assert ((imm7 & 0x7F) != 0);
        int baseEncoding = 0xF000400;
        this.emitInt(instr.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(setQBit) | imm7 << 16 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    public void absVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.twoRegMiscEncoding(ASIMDInstruction.ABS, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void addSSS(ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (eSize == ElementSize.DoubleWord);
        this.scalarThreeSameEncoding(ASIMDInstruction.ADD, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void addVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.ADD, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void addvSV(ASIMDSize size, ElementSize elementSize, Register dst, Register src) {
        assert (size != ASIMDSize.HalfReg || elementSize != ElementSize.Word) : "Invalid size and lane combination for addv";
        assert (elementSize != ElementSize.DoubleWord) : "Invalid lane width for addv";
        this.acrossLanesEncoding(ASIMDInstruction.ADDV, size, AArch64ASIMDAssembler.elemSizeXX(elementSize), dst, src);
    }

    public void andVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.AND, size, 0, dst, src1, src2);
    }

    public void bicVI(ASIMDSize size, Register dst, long imm) {
        this.modifiedImmEncoding(ImmediateOp.BIC, size, dst, imm);
    }

    public void bicVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.BIC, size, 0x400000, dst, src1, src2);
    }

    public void cmeqVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.threeSameEncoding(ASIMDInstruction.CMEQ, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmeqZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.twoRegMiscEncoding(ASIMDInstruction.CMEQ_ZERO, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void cmgeVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.threeSameEncoding(ASIMDInstruction.CMGE, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmgtVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.threeSameEncoding(ASIMDInstruction.CMGT, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmgtZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.twoRegMiscEncoding(ASIMDInstruction.CMGT_ZERO, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void cmhiVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.threeSameEncoding(ASIMDInstruction.CMHI, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmhsVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.threeSameEncoding(ASIMDInstruction.CMHS, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void cmltZeroVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.twoRegMiscEncoding(ASIMDInstruction.CMLT_ZERO, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void cntVV(ASIMDSize size, Register dst, Register src) {
        this.twoRegMiscEncoding(ASIMDInstruction.CNT, size, 0, dst, src);
    }

    public void dupSX(ElementSize eSize, Register dst, Register src, int index) {
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (index >= 0 && index < ASIMDSize.FullReg.bytes() / eSize.bytes());
        int baseEncoding = 1577059328;
        int imm5Encoding = (index * 2 * eSize.bytes() | eSize.bytes()) << 16;
        this.emitInt(ASIMDInstruction.DUPELEM.encoding | baseEncoding | imm5Encoding | AArch64Assembler.rd(dst) | AArch64Assembler.rn(src));
    }

    public void dupVX(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src, int index) {
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.copyEncoding(ASIMDInstruction.DUPELEM, dstSize == ASIMDSize.FullReg, eSize, dst, src, index);
    }

    public void dupVG(ASIMDSize dstSize, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(dstSize, eSize));
        assert (src.getRegisterCategory().equals((Object)AArch64.CPU));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.copyEncoding(ASIMDInstruction.DUPGEN, dstSize == ASIMDSize.FullReg, eSize, dst, src, 0);
    }

    public void eorVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.EOR, size, 0, dst, src1, src2);
    }

    public void extVVV(ASIMDSize size, Register dst, Register src1, Register src2, int src1LowIdx) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1LowIdx >= 0 && src1LowIdx < size.bytes());
        int baseEncoding = 0x2E000000;
        this.emitInt(ASIMDInstruction.EXT.encoding | baseEncoding | AArch64ASIMDAssembler.qBit(size) | src1LowIdx << 11 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void fabsVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.twoRegMiscEncoding(ASIMDInstruction.FABS, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void faddVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        this.threeSameEncoding(ASIMDInstruction.FADD, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fcmeqVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        this.threeSameEncoding(ASIMDInstruction.FCMEQ, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fcmgeVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        this.threeSameEncoding(ASIMDInstruction.FCMGE, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fcmgtVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        this.threeSameEncoding(ASIMDInstruction.FCMGT, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void fcvtlVV(ElementSize srcESize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize == ElementSize.HalfWord || srcESize == ElementSize.Word);
        this.twoRegMiscEncoding(ASIMDInstruction.FCVTL, false, AArch64ASIMDAssembler.elemSize0X(srcESize), dst, src);
    }

    public void fcvtnVV(ElementSize srcESize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize == ElementSize.Word || srcESize == ElementSize.DoubleWord);
        this.twoRegMiscEncoding(ASIMDInstruction.FCVTN, false, AArch64ASIMDAssembler.elemSize0X(srcESize), dst, src);
    }

    public void fcvtzsVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        this.twoRegMiscEncoding(ASIMDInstruction.FCVTZS, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fdivVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.FDIV, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fmaxVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.FMAX, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fminVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.FMIN, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void fmlaVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        this.threeSameEncoding(ASIMDInstruction.FMLA, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fmlsVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        this.threeSameEncoding(ASIMDInstruction.FMLS, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void fmovVI(ASIMDSize size, ElementSize eSize, Register dst, long imm64) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        ImmediateOp op = eSize == ElementSize.DoubleWord ? ImmediateOp.FMOVDP : ImmediateOp.FMOVSP;
        this.modifiedImmEncoding(op, size, dst, imm64);
    }

    public void fmulVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.FMUL, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src1, src2);
    }

    public void fnegVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        this.twoRegMiscEncoding(ASIMDInstruction.FNEG, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fsqrtVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.twoRegMiscEncoding(ASIMDInstruction.FSQRT, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src);
    }

    public void fsubVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.FSUB, size, AArch64ASIMDAssembler.elemSize1X(eSize), dst, src1, src2);
    }

    public void mlaVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.MLA, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void mlsVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.MLS, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void moviVI(ASIMDSize size, Register dst, long imm) {
        this.modifiedImmEncoding(ImmediateOp.MOVI, size, dst, imm);
    }

    public void mulVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.MUL, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void mvniVI(ASIMDSize size, Register dst, long imm) {
        this.modifiedImmEncoding(ImmediateOp.MVNI, size, dst, imm);
    }

    public void negVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.twoRegMiscEncoding(ASIMDInstruction.NEG, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src);
    }

    public void notVV(ASIMDSize size, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.twoRegMiscEncoding(ASIMDInstruction.NOT, size, 0, dst, src);
    }

    public void ornVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.ORN, size, 0xC00000, dst, src1, src2);
    }

    public void orrVI(ASIMDSize size, Register dst, long imm) {
        this.modifiedImmEncoding(ImmediateOp.ORR, size, dst, imm);
    }

    public void orrVVV(ASIMDSize size, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.ORR, size, 0x800000, dst, src1, src2);
    }

    public void saddlvSV(ASIMDSize size, ElementSize elementSize, Register dst, Register src) {
        assert (size != ASIMDSize.HalfReg || elementSize != ElementSize.Word) : "Invalid size and lane combination for saddlv";
        assert (elementSize != ElementSize.DoubleWord) : "Invalid lane width for saddlv";
        this.acrossLanesEncoding(ASIMDInstruction.SADDLV, size, AArch64ASIMDAssembler.elemSizeXX(elementSize), dst, src);
    }

    public void scvtfVV(ASIMDSize size, ElementSize eSize, Register dst, Register src) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (eSize == ElementSize.Word || eSize == ElementSize.DoubleWord);
        this.twoRegMiscEncoding(ASIMDInstruction.SCVTF, size, AArch64ASIMDAssembler.elemSize0X(eSize), dst, src);
    }

    public void shlVVI(ASIMDSize size, ElementSize eSize, Register dst, Register src, int shiftAmt) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (shiftAmt >= 0 && shiftAmt < eSize.nbits);
        int imm7 = eSize.nbits + shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.SHL, size, imm7, dst, src);
    }

    public void smaxVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.SMAX, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void sminVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.SMIN, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void smlalVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize != ElementSize.DoubleWord);
        this.threeDifferentEncoding(ASIMDInstruction.SMLAL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void smlslVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize != ElementSize.DoubleWord);
        this.threeDifferentEncoding(ASIMDInstruction.SMLSL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void smovGX(ElementSize dstESize, ElementSize srcESize, Register dst, Register src, int index) {
        assert (srcESize != ElementSize.DoubleWord);
        assert (dstESize == ElementSize.Word || dstESize == ElementSize.DoubleWord);
        assert (srcESize.nbits < dstESize.nbits) : "the target size must be larger than the source size";
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.copyEncoding(ASIMDInstruction.SMOV, dstESize == ElementSize.DoubleWord, srcESize, dst, src, index);
    }

    public void sshlVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.SSHL, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void sshllVVI(ElementSize srcESize, Register dst, Register src, int shiftAmt) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize != ElementSize.DoubleWord);
        assert (shiftAmt >= 0 && shiftAmt < srcESize.nbits);
        int imm7 = srcESize.nbits + shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.SSHLL, false, imm7, dst, src);
    }

    public void sshrVVI(ASIMDSize size, ElementSize eSize, Register dst, Register src, int shiftAmt) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (shiftAmt > 0 && shiftAmt <= eSize.nbits);
        int imm7 = eSize.nbits * 2 - shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.SSHR, size, imm7, dst, src);
    }

    public void subSSS(ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (eSize == ElementSize.DoubleWord);
        this.scalarThreeSameEncoding(ASIMDInstruction.SUB, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void subVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.SUB, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void uaddlvSV(ASIMDSize size, ElementSize elementSize, Register dst, Register src) {
        assert (size != ASIMDSize.HalfReg || elementSize != ElementSize.Word) : "Invalid size and lane combination for uaddlv";
        assert (elementSize != ElementSize.DoubleWord) : "Invalid lane width for uaddlv";
        this.acrossLanesEncoding(ASIMDInstruction.UADDLV, size, AArch64ASIMDAssembler.elemSizeXX(elementSize), dst, src);
    }

    public void umlalVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize != ElementSize.DoubleWord);
        this.threeDifferentEncoding(ASIMDInstruction.UMLAL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void umlslVVV(ElementSize srcESize, Register dst, Register src1, Register src2) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize != ElementSize.DoubleWord);
        this.threeDifferentEncoding(ASIMDInstruction.UMLSL, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src1, src2);
    }

    public void umovGX(ElementSize eSize, Register dst, Register src, int index) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.CPU));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.copyEncoding(ASIMDInstruction.UMOV, eSize == ElementSize.DoubleWord, eSize, dst, src, index);
    }

    public void ushlVVV(ASIMDSize size, ElementSize eSize, Register dst, Register src1, Register src2) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src1.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src2.getRegisterCategory().equals((Object)AArch64.SIMD));
        this.threeSameEncoding(ASIMDInstruction.USHL, size, AArch64ASIMDAssembler.elemSizeXX(eSize), dst, src1, src2);
    }

    public void ushllVVI(ElementSize srcESize, Register dst, Register src, int shiftAmt) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize != ElementSize.DoubleWord);
        assert (shiftAmt >= 0 && shiftAmt < srcESize.nbits);
        int imm7 = srcESize.nbits + shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.USHLL, false, imm7, dst, src);
    }

    public void ushrVVI(ASIMDSize size, ElementSize eSize, Register dst, Register src, int shiftAmt) {
        assert (AArch64ASIMDAssembler.usesMultipleLanes(size, eSize));
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (shiftAmt > 0 && shiftAmt <= eSize.nbits);
        int imm7 = eSize.nbits * 2 - shiftAmt;
        this.shiftByImmEncoding(ASIMDInstruction.USHR, size, imm7, dst, src);
    }

    public void xtnVV(ElementSize srcESize, Register dst, Register src) {
        assert (dst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (src.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (srcESize != ElementSize.Byte);
        this.twoRegMiscEncoding(ASIMDInstruction.XTN, false, AArch64ASIMDAssembler.elemSizeXX(srcESize), dst, src);
    }

    public static enum ASIMDInstruction {
        EXT(0),
        DUPELEM(0),
        DUPGEN(2048),
        SMOV(10240),
        UMOV(14336),
        CNT(20480),
        CMGT_ZERO(32768),
        CMEQ_ZERO(36864),
        CMLT_ZERO(40960),
        ABS(45056),
        XTN(73728),
        FCVTN(90112),
        FCVTL(94208),
        SCVTF(118784),
        FABS(61440),
        FCVTZS(110592),
        NEG(0x2000B000),
        NOT(0x20005000),
        FNEG(0x2000F000),
        FSQRT(536997888),
        SADDLV(12288),
        ADDV(110592),
        UADDLV(0x20003000),
        SMLAL(32768),
        SMLSL(40960),
        UMLAL(0x20008000),
        UMLSL(0x2000A000),
        CMGT(12288),
        CMGE(14336),
        SSHL(16384),
        SMAX(24576),
        SMIN(26624),
        ADD(32768),
        MLA(36864),
        MUL(38912),
        FMLA(51200),
        FADD(53248),
        FCMEQ(57344),
        FMAX(61440),
        AND(6144),
        BIC(6144),
        FMLS(51200),
        FSUB(53248),
        FMIN(61440),
        ORR(6144),
        ORN(6144),
        CMHI(0x20003000),
        CMHS(536885248),
        USHL(0x20004000),
        SUB(0x20008000),
        CMEQ(0x20008800),
        MLS(0x20009000),
        FMUL(536926208),
        FCMGE(0x2000E000),
        FDIV(536934400),
        EOR(536877056),
        FCMGT(0x2000E000),
        SSHR(0),
        SHL(20480),
        SSHLL(40960),
        USHR(0x20000000),
        USHLL(0x2000A000);

        public final int encoding;

        private ASIMDInstruction(int encoding) {
            this.encoding = encoding;
        }
    }

    public static enum ElementSize {
        Byte(0, 8),
        HalfWord(1, 16),
        Word(2, 32),
        DoubleWord(3, 64);

        private final int encoding;
        private final int nbits;

        private ElementSize(int encoding, int nbits) {
            this.encoding = encoding;
            this.nbits = nbits;
        }

        public int bits() {
            return this.nbits;
        }

        public int bytes() {
            return this.nbits / 8;
        }

        public static ElementSize fromKind(PlatformKind kind) {
            switch (((AArch64Kind)kind).getScalar()) {
                case BYTE: {
                    return Byte;
                }
                case WORD: {
                    return HalfWord;
                }
                case DWORD: 
                case SINGLE: {
                    return Word;
                }
                case QWORD: 
                case DOUBLE: {
                    return DoubleWord;
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        private static ElementSize fromSize(int size) {
            switch (size) {
                case 8: {
                    return Byte;
                }
                case 16: {
                    return HalfWord;
                }
                case 32: {
                    return Word;
                }
                case 64: {
                    return DoubleWord;
                }
            }
            throw GraalError.shouldNotReachHere("Invalid ASIMD element size.");
        }

        public ElementSize expand() {
            return ElementSize.fromSize(this.nbits * 2);
        }

        public ElementSize narrow() {
            return ElementSize.fromSize(this.nbits / 2);
        }
    }

    public static final class ASIMDSize
    extends Enum<ASIMDSize> {
        public static final /* enum */ ASIMDSize HalfReg = new ASIMDSize(64);
        public static final /* enum */ ASIMDSize FullReg = new ASIMDSize(128);
        private final int nbits;
        private static final /* synthetic */ ASIMDSize[] $VALUES;

        public static ASIMDSize[] values() {
            return (ASIMDSize[])$VALUES.clone();
        }

        public static ASIMDSize valueOf(String name) {
            return Enum.valueOf(ASIMDSize.class, name);
        }

        private ASIMDSize(int nbits) {
            this.nbits = nbits;
        }

        public int bits() {
            return this.nbits;
        }

        public int bytes() {
            return this.nbits / 8;
        }

        public static ASIMDSize fromVectorKind(PlatformKind kind) {
            assert (kind instanceof AArch64Kind);
            assert (kind.getVectorLength() > 0);
            int bitSize = kind.getSizeInBytes() * 8;
            assert (bitSize == 32 || bitSize == 64 || bitSize == 128);
            return bitSize == 128 ? FullReg : HalfReg;
        }

        static {
            $VALUES = new ASIMDSize[]{HalfReg, FullReg};
        }
    }

    public static enum ImmediateOp {
        MOVI,
        MVNI,
        ORR,
        BIC,
        FMOVSP,
        FMOVDP;

        private static byte[] moviEncodings;
        private static byte[] mvniEncodings;
        private static byte[] orrEncodings;
        private static byte[] bicEncodings;
        private static byte[] fmovSPEncodings;
        private static byte[] fmovDPEncodings;

        public static byte[] getCmodeOpEncodings(ImmediateOp op) {
            switch (op) {
                case MOVI: {
                    return moviEncodings;
                }
                case MVNI: {
                    return mvniEncodings;
                }
                case ORR: {
                    return orrEncodings;
                }
                case BIC: {
                    return bicEncodings;
                }
                case FMOVSP: {
                    return fmovSPEncodings;
                }
                case FMOVDP: {
                    return fmovDPEncodings;
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        static {
            moviEncodings = new byte[]{0, 4, 8, 12, 16, 20, 24, 26, 28, 29, 30};
            mvniEncodings = new byte[]{1, 5, 9, 13, 17, 21, 25, 27};
            orrEncodings = new byte[]{2, 6, 10, 14, 18, 22};
            bicEncodings = new byte[]{3, 7, 11, 15, 19, 23};
            fmovSPEncodings = new byte[]{30};
            fmovDPEncodings = new byte[]{31};
        }
    }

    public static class ASIMDImmediateTable {
        private static final int ImmediateOpOffset = 29;
        private static final int ImmediateCmodeOffset = 12;
        private static final int ImmediateABCOffset = 16;
        private static final int ImmediateDEFGHOffset = 5;
        public static final ImmediateEncodings[] IMMEDIATE_TABLE = ASIMDImmediateTable.buildImmediateTable();

        public static boolean isEncodable(long imm, ImmediateOp op) {
            int pos = Arrays.binarySearch(IMMEDIATE_TABLE, ImmediateEncodings.createRepresentativeEncoding(imm));
            if (pos < 0) {
                return false;
            }
            ImmediateEncodings immediate = IMMEDIATE_TABLE[pos];
            for (byte cmodeOpEncoding : ImmediateOp.getCmodeOpEncodings(op)) {
                if (!immediate.validEncoding[cmodeOpEncoding]) continue;
                return true;
            }
            return false;
        }

        public static int getEncoding(long imm, ImmediateOp op) {
            assert (ASIMDImmediateTable.isEncodable(imm, op));
            int pos = Arrays.binarySearch(IMMEDIATE_TABLE, ImmediateEncodings.createRepresentativeEncoding(imm));
            ImmediateEncodings immediate = IMMEDIATE_TABLE[pos];
            for (byte cmodeOpEncoding : ImmediateOp.getCmodeOpEncodings(op)) {
                if (!immediate.validEncoding[cmodeOpEncoding]) continue;
                int imm8Encoding = ASIMDImmediateTable.getImm8Encoding(immediate.imm8[cmodeOpEncoding]);
                int opBit = cmodeOpEncoding & 1;
                int cmodeBits = cmodeOpEncoding >> 1 & 0xF;
                return imm8Encoding | opBit << 29 | cmodeBits << 12;
            }
            throw GraalError.shouldNotReachHere("Unable to encode immediate");
        }

        private static int getImm8Encoding(byte imm8) {
            int encoding = (imm8 >>> 5 & 7) << 16 | (imm8 & 0x1F) << 5;
            return encoding;
        }

        private static long[] asBitArray(long imm8) {
            long[] bitArray = new long[8];
            long remaining = imm8;
            for (int i = 0; i < 8; ++i) {
                bitArray[i] = remaining & 1L;
                remaining >>= 1;
            }
            return bitArray;
        }

        private static int getCmodeOpEncoding(int cmodeBits3to1, int cmodeBit0, int op) {
            int encoding = cmodeBits3to1 << 2 | cmodeBit0 << 1 | op;
            return encoding;
        }

        private static long replicateBit(long bit, int repeatNum) {
            if (bit == 0L) {
                return 0L;
            }
            assert (bit == 1L);
            return (1L << repeatNum) - 1L;
        }

        private static long notBit(long bit) {
            if (bit == 0L) {
                return 1L;
            }
            assert (bit == 1L);
            return 0L;
        }

        private static void registerImmediate(Map<Long, ImmediateEncodings> immediateMap, long imm64, long imm8, int cmodeBits3to1, BitValues cmodeBit0, BitValues op) {
            immediateMap.compute(imm64, (k, v) -> v == null ? new ImmediateEncodings((long)k, (byte)imm8, cmodeBits3to1, cmodeBit0, op) : v.addEncoding(imm64, (byte)imm8, cmodeBits3to1, cmodeBit0, op));
        }

        private static ImmediateEncodings[] buildImmediateTable() {
            HashMap<Long, ImmediateEncodings> immediateMap = new HashMap<Long, ImmediateEncodings>();
            for (long imm8 = 0L; imm8 < 256L; ++imm8) {
                long imm64 = imm8 << 32 | imm8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 0, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 40 | imm8 << 8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 1, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 48 | imm8 << 16;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 2, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 56 | imm8 << 24;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 3, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 48 | imm8 << 32 | imm8 << 16 | imm8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 4, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 56 | imm8 << 40 | imm8 << 24 | imm8 << 8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 5, BitValues.ANY, BitValues.ANY);
                imm64 = imm8 << 40 | 0xFF00000000L | imm8 << 8 | 0xFFL;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 6, BitValues.ZERO, BitValues.ANY);
                imm64 = imm8 << 48 | 0xFFFF00000000L | imm8 << 16 | 0xFFFFL;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 6, BitValues.ONE, BitValues.ANY);
                long[] bitArray = ASIMDImmediateTable.asBitArray(imm8);
                imm64 = imm8 << 56 | imm8 << 48 | imm8 << 40 | imm8 << 32 | imm8 << 24 | imm8 << 16 | imm8 << 8 | imm8;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 7, BitValues.ZERO, BitValues.ZERO);
                imm64 = ASIMDImmediateTable.replicateBit(bitArray[7], 8) << 56 | ASIMDImmediateTable.replicateBit(bitArray[6], 8) << 48 | ASIMDImmediateTable.replicateBit(bitArray[5], 8) << 40 | ASIMDImmediateTable.replicateBit(bitArray[4], 8) << 32 | ASIMDImmediateTable.replicateBit(bitArray[3], 8) << 24 | ASIMDImmediateTable.replicateBit(bitArray[2], 8) << 16 | ASIMDImmediateTable.replicateBit(bitArray[1], 8) << 8 | ASIMDImmediateTable.replicateBit(bitArray[0], 8);
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 7, BitValues.ZERO, BitValues.ONE);
                long imm32 = bitArray[7] << 31 | ASIMDImmediateTable.notBit(bitArray[6]) << 30 | ASIMDImmediateTable.replicateBit(bitArray[6], 5) << 25 | (imm8 & 0x3FL) << 19;
                imm64 = imm32 << 32 | imm32;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 7, BitValues.ONE, BitValues.ZERO);
                imm64 = bitArray[7] << 63 | ASIMDImmediateTable.notBit(bitArray[6]) << 62 | ASIMDImmediateTable.replicateBit(bitArray[6], 8) << 54 | (imm8 & 0x3FL) << 48;
                ASIMDImmediateTable.registerImmediate(immediateMap, imm64, imm8, 7, BitValues.ONE, BitValues.ONE);
            }
            Object[] table = immediateMap.values().toArray(new ImmediateEncodings[0]);
            Arrays.sort(table);
            return table;
        }

        private static final class ImmediateEncodings
        implements Comparable<ImmediateEncodings> {
            public final long imm;
            private final boolean[] validEncoding;
            private final byte[] imm8;

            private ImmediateEncodings(long imm) {
                this.imm = imm;
                this.validEncoding = null;
                this.imm8 = null;
            }

            public static ImmediateEncodings createRepresentativeEncoding(long imm) {
                return new ImmediateEncodings(imm);
            }

            ImmediateEncodings(long imm, byte imm8Val, int cmodeBits3to1, BitValues cmodeBit0, BitValues op) {
                this.imm = imm;
                this.validEncoding = new boolean[32];
                this.imm8 = new byte[32];
                for (int bit0 : cmodeBit0.values) {
                    for (int opBit : op.values) {
                        int cmodeOpEncoding = ASIMDImmediateTable.getCmodeOpEncoding(cmodeBits3to1, bit0, opBit);
                        assert (!this.validEncoding[cmodeOpEncoding]);
                        this.validEncoding[cmodeOpEncoding] = true;
                        this.imm8[cmodeOpEncoding] = imm8Val;
                    }
                }
            }

            public ImmediateEncodings addEncoding(long imm64, byte imm8Val, int cmodeBits3to1, BitValues cmodeBit0, BitValues op) {
                assert (imm64 == this.imm);
                for (int bit0 : cmodeBit0.values) {
                    for (int opBit : op.values) {
                        int cmodeOpEncoding = ASIMDImmediateTable.getCmodeOpEncoding(cmodeBits3to1, bit0, opBit);
                        assert (!this.validEncoding[cmodeOpEncoding]);
                        this.validEncoding[cmodeOpEncoding] = true;
                        this.imm8[cmodeOpEncoding] = imm8Val;
                    }
                }
                return this;
            }

            @Override
            public int compareTo(ImmediateEncodings o) {
                return Long.compare(this.imm, o.imm);
            }
        }

        public static enum BitValues {
            ZERO(0),
            ONE(1),
            ANY(0, 1);

            final int[] values;

            private BitValues(int ... values) {
                this.values = values;
            }
        }
    }
}

