/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HotSpotTruffleRuntimeServices {
    private static final Constructor<? extends SpeculationLog> sharedHotSpotSpeculationLogConstructor;

    HotSpotTruffleRuntimeServices() {
    }

    public static SpeculationLog getCompilationSpeculationLog(OptimizedCallTarget callTarget) {
        if (sharedHotSpotSpeculationLogConstructor != null) {
            HotSpotSpeculationLog masterLog = (HotSpotSpeculationLog)callTarget.getSpeculationLog();
            try {
                SpeculationLog compilationSpeculationLog = sharedHotSpotSpeculationLogConstructor.newInstance(masterLog);
                compilationSpeculationLog.collectFailedSpeculations();
                return compilationSpeculationLog;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new InternalError(e);
            }
        }
        SpeculationLog log = callTarget.getSpeculationLog();
        if (log != null) {
            log.collectFailedSpeculations();
        }
        return log;
    }

    static {
        Constructor<?> constructor = null;
        try {
            Class<?> theClass = Class.forName("jdk.vm.ci.hotspot.SharedHotSpotSpeculationLog");
            constructor = theClass.getDeclaredConstructor(HotSpotSpeculationLog.class);
        }
        catch (ClassNotFoundException theClass) {
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("SharedHotSpotSpeculationLog exists but constructor is missing", e);
        }
        sharedHotSpotSpeculationLogConstructor = constructor;
    }
}

