/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.graalvm.libgraal.jni.annotation.FromLibGraalId;
import org.graalvm.libgraal.jni.annotation.JNIFromLibGraalRepeated;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Repeatable(value=JNIFromLibGraalRepeated.class)
@Retention(value=RetentionPolicy.SOURCE)
@Target(value={ElementType.METHOD})
public @interface JNIFromLibGraal {
    public Id value();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Id implements FromLibGraalId
    {
        CreateException(Throwable.class, String.class),
        GetClassName(String.class, Class.class),
        GetStackTrace(StackTraceElement[].class, Throwable.class),
        GetStackTraceElementClassName(String.class, StackTraceElement.class),
        GetStackTraceElementFileName(String.class, StackTraceElement.class),
        GetStackTraceElementLineNumber(Integer.TYPE, StackTraceElement.class),
        GetStackTraceElementMethodName(String.class, StackTraceElement.class),
        GetThrowableMessage(String.class, Throwable.class),
        UpdateStackTrace(Throwable.class, Throwable.class, String[].class);

        private final String signature;
        private final String methodName;
        private final Class<?> returnType;
        private final Class<?>[] parameterTypes;

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public Class<?> getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.methodName + this.signature;
        }

        private Id(Class<?> returnType, Class<?> ... parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.signature = FromLibGraalId.encodeMethodSignature(returnType, parameterTypes);
            this.methodName = Character.toLowerCase(this.name().charAt(0)) + this.name().substring(1);
        }
    }
}

