/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.libgraal.LibGraalScope;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LibGraal {
    private static final Method unhand;
    private static final Method translate;
    private static final Method registerNativeMethods;
    private static final Method isCurrentThreadAttached;
    private static final Method attachCurrentThread;
    private static final Method detachCurrentThread;
    private static final Method getFailedSpeculationsAddress;
    static final long initialIsolate;
    static final boolean available;

    public static boolean isAvailable() {
        return LibGraal.inLibGraal() || available;
    }

    public static boolean isSupported() {
        return getFailedSpeculationsAddress != null;
    }

    public static boolean inLibGraal() {
        return Services.IS_IN_NATIVE_IMAGE;
    }

    public static void registerNativeMethods(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (LibGraal.inLibGraal() || !LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        try {
            registerNativeMethods.invoke((Object)HotSpotJVMCIRuntime.runtime(), clazz);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static long translate(Object obj) {
        if (!LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        try {
            return (Long)translate.invoke((Object)HotSpotJVMCIRuntime.runtime(), obj);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static <T> T unhand(Class<T> type, long handle) {
        if (!LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        try {
            return (T)unhand.invoke((Object)HotSpotJVMCIRuntime.runtime(), type, handle);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    private static long initializeLibgraal() {
        if (registerNativeMethods == null) {
            return 0L;
        }
        try {
            long[] javaVMInfo = (long[])registerNativeMethods.invoke((Object)HotSpotJVMCIRuntime.runtime(), LibGraalScope.class);
            long isolate = javaVMInfo[1];
            return isolate;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof UnsupportedOperationException) {
                return 0L;
            }
            throw new InternalError(e);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    static boolean isCurrentThreadAttached() {
        try {
            return (Boolean)isCurrentThreadAttached.invoke((Object)HotSpotJVMCIRuntime.runtime(), new Object[0]);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static boolean attachCurrentThread(boolean isDaemon, long[] isolate) {
        try {
            if (attachCurrentThread.getParameterCount() == 2) {
                long[] javaVMInfo = isolate != null ? new long[4] : null;
                boolean res = (Boolean)attachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), isDaemon, javaVMInfo);
                if (isolate != null) {
                    isolate[0] = javaVMInfo[1];
                }
                return res;
            }
            if (isolate != null) {
                isolate[0] = initialIsolate;
            }
            return (Boolean)attachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), isDaemon);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static boolean detachCurrentThread(boolean release) {
        try {
            if (detachCurrentThread.getParameterCount() == 1) {
                return (Boolean)detachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), release);
            }
            detachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), new Object[0]);
            return false;
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static long getFailedSpeculationsAddress(HotSpotSpeculationLog log) {
        if (getFailedSpeculationsAddress != null) {
            try {
                return (Long)getFailedSpeculationsAddress.invoke((Object)log, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new UnsupportedOperationException();
    }

    static {
        Services.initializeJVMCI();
        unhand = LibGraalScope.methodOrNull(HotSpotJVMCIRuntime.class, "unhand", new Class[][]{LibGraalScope.sig(Class.class, Long.TYPE)});
        translate = LibGraalScope.methodIf(unhand, HotSpotJVMCIRuntime.class, "translate", new Class[][]{LibGraalScope.sig(Object.class)});
        registerNativeMethods = LibGraalScope.methodIf(unhand, HotSpotJVMCIRuntime.class, "registerNativeMethods", new Class[][]{LibGraalScope.sig(Class.class)});
        isCurrentThreadAttached = LibGraalScope.methodIf(unhand, HotSpotJVMCIRuntime.class, "isCurrentThreadAttached", new Class[0][]);
        attachCurrentThread = LibGraalScope.methodIf(unhand, HotSpotJVMCIRuntime.class, "attachCurrentThread", LibGraalScope.sig(Boolean.TYPE, long[].class), LibGraalScope.sig(Boolean.TYPE));
        detachCurrentThread = LibGraalScope.methodIf(unhand, HotSpotJVMCIRuntime.class, "detachCurrentThread", LibGraalScope.sig(Boolean.TYPE), LibGraalScope.sig(new Class[0]));
        getFailedSpeculationsAddress = LibGraalScope.methodIf(unhand, HotSpotSpeculationLog.class, "getFailedSpeculationsAddress", new Class[0][]);
        initialIsolate = Services.IS_BUILDING_NATIVE_IMAGE ? 0L : LibGraal.initializeLibgraal();
        available = initialIsolate != 0L;
    }
}

