/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.TruffleFromLibGraal;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalCompilationResultInfo;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalGraphInfo;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalStringSupplier;
import org.graalvm.libgraal.LibGraal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class TruffleFromLibGraalEntryPoints {
    static final /* synthetic */ boolean $assertionsDisabled;

    TruffleFromLibGraalEntryPoints() {
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.ConsumeOptimizedAssumptionDependency)
    static void consumeOptimizedAssumptionDependency(Consumer<OptimizedAssumptionDependency> consumer, Object dep) {
        consumer.accept((OptimizedAssumptionDependency)dep);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CountInlinedCalls)
    static int countInlinedCalls(Object provider) {
        return ((TruffleMetaAccessProvider)provider).countInlinedCalls();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallTargetForCallNode)
    static long getCallTargetForCallNode(Object truffleRuntime, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        JavaConstant callTarget = ((TruffleCompilerRuntime)truffleRuntime).getCallTargetForCallNode(callNode);
        return LibGraal.translate(callTarget);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsTruffleBoundary)
    static boolean isTruffleBoundary(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).isTruffleBoundary(method);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSpecializationMethod)
    static boolean isSpecializationMethod(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).isSpecializationMethod(method);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsBytecodeInterpreterSwitch)
    static boolean isBytecodeInterpreterSwitch(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).isBytecodeInterpreterSwitch(method);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsBytecodeInterpreterSwitchBoundary)
    static boolean isBytecodeInterpreterSwitchBoundary(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).isBytecodeInterpreterSwitchBoundary(method);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsValueType)
    static boolean isValueType(Object truffleRuntime, long typeHandle) {
        ResolvedJavaType type = LibGraal.unhand(ResolvedJavaType.class, typeHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).isValueType(type);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetInlineKind)
    static int getInlineKind(Object truffleRuntime, long methodHandle, boolean duringPartialEvaluation) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        TruffleCompilerRuntime.InlineKind inlineKind = ((TruffleCompilerRuntime)truffleRuntime).getInlineKind(method, duringPartialEvaluation);
        return inlineKind.ordinal();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLoopExplosionKind)
    static int getLoopExplosionKind(Object truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(ResolvedJavaMethod.class, methodHandle);
        TruffleCompilerRuntime.LoopExplosionKind loopExplosionKind = ((TruffleCompilerRuntime)truffleRuntime).getLoopExplosionKind(method);
        return loopExplosionKind.ordinal();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetConstantFieldInfo)
    static int getConstantFieldInfo(Object truffleRuntime, long typeHandle, boolean isStatic, int fieldIndex) {
        ResolvedJavaType enclosing = LibGraal.unhand(ResolvedJavaType.class, typeHandle);
        ResolvedJavaField[] declaredFields = isStatic ? enclosing.getStaticFields() : enclosing.getInstanceFields(false);
        ResolvedJavaField field = declaredFields[fieldIndex];
        TruffleCompilerRuntime.ConstantFieldInfo constantFieldInfo = ((TruffleCompilerRuntime)truffleRuntime).getConstantFieldInfo(field);
        if (constantFieldInfo == null) {
            return Integer.MIN_VALUE;
        }
        if (constantFieldInfo.isChildren()) {
            return -2;
        }
        if (constantFieldInfo.isChild()) {
            return -1;
        }
        return constantFieldInfo.getDimensions();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetJavaKindForFrameSlotKind)
    static int getJavaKindForFrameSlotKind(Object truffleRuntime, int frameSlotKindTag) {
        return ((TruffleCompilerRuntime)truffleRuntime).getJavaKindForFrameSlotKind(frameSlotKindTag).ordinal();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFrameSlotKindTagsCount)
    static int getFrameSlotKindTagsCount(Object truffleRuntime) {
        return ((TruffleCompilerRuntime)truffleRuntime).getFrameSlotKindTagsCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFrameSlotKindTagForJavaKind)
    static int getFrameSlotKindTagForJavaKind(Object truffleRuntime, int ordinal) {
        return ((TruffleCompilerRuntime)truffleRuntime).getFrameSlotKindTagForJavaKind(JavaKind.values()[ordinal]);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetTruffleCallBoundaryMethods)
    static long[] getTruffleCallBoundaryMethods(Object truffleRuntime) {
        ArrayList<ResolvedJavaMethod> source;
        Iterable<ResolvedJavaMethod> iterable = ((HotSpotTruffleCompilerRuntime)truffleRuntime).getTruffleCallBoundaryMethods();
        if (iterable instanceof Collection) {
            source = (ArrayList<ResolvedJavaMethod>)iterable;
        } else {
            source = new ArrayList<ResolvedJavaMethod>();
            for (ResolvedJavaMethod m : iterable) {
                source.add(m);
            }
        }
        long[] res = new long[source.size()];
        int i = 0;
        for (ResolvedJavaMethod m : source) {
            res[i++] = LibGraal.translate(m);
        }
        return res;
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.Log)
    static void log(Object truffleRuntime, String loggerId, Object compilable, String message) {
        ((TruffleCompilerRuntime)truffleRuntime).log(loggerId, (CompilableTruffleAST)compilable, message);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateInliningPlan)
    static Object createInliningPlan(Object truffleRuntime) {
        return ((TruffleCompilerRuntime)truffleRuntime).createInliningPlan();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.RegisterOptimizedAssumptionDependency)
    static Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(Object truffleRuntime, long optimizedAssumptionHandle) {
        JavaConstant optimizedAssumption = LibGraal.unhand(JavaConstant.class, optimizedAssumptionHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).registerOptimizedAssumptionDependency(optimizedAssumption);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AsCompilableTruffleAST)
    static Object asCompilableTruffleAST(Object truffleRuntime, long constantHandle) {
        JavaConstant constant = LibGraal.unhand(JavaConstant.class, constantHandle);
        return ((TruffleCompilerRuntime)truffleRuntime).asCompilableTruffleAST(constant);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSuppressedFailure)
    static boolean isSuppressedFailure(Object truffleRuntime, Object compilable, Supplier<String> serializedException) {
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).isSuppressedFailure((CompilableTruffleAST)compilable, serializedException);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetPosition)
    static Object getPosition(Object inliningPlan, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        return ((TruffleMetaAccessProvider)inliningPlan).getPosition(callNode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeRewritingAssumptionConstant)
    static long getNodeRewritingAssumptionConstant(Object compilable) {
        JavaConstant assumption = ((CompilableTruffleAST)compilable).getNodeRewritingAssumptionConstant();
        return LibGraal.translate(assumption);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetValidRootAssumptionConstant)
    static long getValidRootAssumptionConstant(Object compilable) {
        JavaConstant assumption = ((CompilableTruffleAST)compilable).getValidRootAssumptionConstant();
        return LibGraal.translate(assumption);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetURI)
    static String getURI(Object position) {
        URI uri = ((TruffleSourceLanguagePosition)position).getURI();
        return uri == null ? null : uri.toString();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AsJavaConstant)
    static long asJavaConstant(Object compilable) {
        JavaConstant constant = ((CompilableTruffleAST)compilable).asJavaConstant();
        return LibGraal.translate(constant);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCodeInstallation)
    static void onCodeInstallation(Object truffleRuntime, Object compilable, long installedCodeHandle) {
        InstalledCode installedCode = LibGraal.unhand(InstalledCode.class, installedCodeHandle);
        ((HotSpotTruffleCompilerRuntime)truffleRuntime).onCodeInstallation((CompilableTruffleAST)compilable, installedCode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetFailedSpeculationsAddress)
    static long getFailedSpeculationsAddress(Object compilable) {
        OptimizedCallTarget callTarget = (OptimizedCallTarget)compilable;
        HotSpotSpeculationLog log = (HotSpotSpeculationLog)callTarget.getSpeculationLog();
        return LibGraal.getFailedSpeculationsAddress(log);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CreateStringSupplier)
    static Supplier<String> createStringSupplier(long handle) {
        return new LibGraalStringSupplier(handle);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetSuppliedString)
    static String getSuppliedString(Supplier<String> supplier) {
        return supplier.get();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsCancelled)
    static boolean isCancelled(Object task) {
        return ((TruffleCompilationTask)task).isCancelled();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsLastTier)
    static boolean isLastTier(Object task) {
        return ((TruffleCompilationTask)task).isLastTier();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CompilableToString)
    static String compilableToString(Object compilable) {
        return ((CompilableTruffleAST)compilable).toString();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilableName)
    static String getCompilableName(Object compilable) {
        return ((CompilableTruffleAST)compilable).getName();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetDescription)
    static String getDescription(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getDescription();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLanguage)
    static String getLanguage(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getLanguage();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetLineNumber)
    static int getLineNumber(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getLineNumber();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetOffsetEnd)
    static int getOffsetEnd(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getOffsetEnd();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetOffsetStart)
    static int getOffsetStart(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getOffsetStart();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeClassName)
    static String getNodeClassName(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getNodeClassName();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNodeId)
    static int getNodeId(Object pos) {
        return ((TruffleSourceLanguagePosition)pos).getNodeId();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCompilationFailed)
    static void onCompilationFailed(Object compilable, Supplier<String> serializedException, boolean silent, boolean bailout, boolean permanentBailout, boolean graphTooBig) {
        ((CompilableTruffleAST)compilable).onCompilationFailed(serializedException, silent, bailout, permanentBailout, graphTooBig);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnSuccess)
    static void onSuccess(Object listener, Object compilable, Object plan, long graphInfoHandle, long compilationResultInfoHandle, int tier) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);
             LibGraalCompilationResultInfo compilationResultInfo = new LibGraalCompilationResultInfo(compilationResultInfoHandle);){
            ((TruffleCompilerListener)listener).onSuccess((CompilableTruffleAST)compilable, (TruffleMetaAccessProvider)plan, graphInfo, compilationResultInfo, tier);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnFailure)
    static void onFailure(Object listener, Object compilable, String reason, boolean bailout, boolean permanentBailout, int tier) {
        ((TruffleCompilerListener)listener).onFailure((CompilableTruffleAST)compilable, reason, bailout, permanentBailout, tier);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnCompilationRetry)
    static void onCompilationRetry(Object listener, Object compilable, int tier) {
        ((TruffleCompilerListener)listener).onCompilationRetry((CompilableTruffleAST)compilable, tier);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnGraalTierFinished)
    static void onGraalTierFinished(Object listener, Object compilable, long graphInfoHandle) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);){
            ((TruffleCompilerListener)listener).onGraalTierFinished((CompilableTruffleAST)compilable, graphInfo);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.OnTruffleTierFinished)
    static void onTruffleTierFinished(Object listener, Object compilable, Object plan, long graphInfoHandle) {
        try (LibGraalGraphInfo graphInfo = new LibGraalGraphInfo(graphInfoHandle);){
            ((TruffleCompilerListener)listener).onTruffleTierFinished((CompilableTruffleAST)compilable, (TruffleMetaAccessProvider)plan, graphInfo);
        }
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CancelCompilation)
    static boolean cancelCompilation(Object compilableTruffleAST, String reason) {
        return ((CompilableTruffleAST)compilableTruffleAST).cancelCompilation(reason);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.DequeueInlined)
    static void dequeueInlined(Object compilableTruffleAST) {
        ((CompilableTruffleAST)compilableTruffleAST).dequeueInlined();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.FindCallNode)
    static Object findCallNode(Object provider, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(JavaConstant.class, callNodeHandle);
        return ((TruffleMetaAccessProvider)provider).findCallNode(callNode);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallCount)
    static int getCallCount(Object callNode) {
        return ((TruffleCallNode)callNode).getCallCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCurrentCallTarget)
    static Object getCurrentCallTarget(Object truffleCallNode) {
        return ((TruffleCallNode)truffleCallNode).getCurrentCallTarget();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsInliningForced)
    static boolean isInliningForced(Object truffleCallNode) {
        return ((TruffleCallNode)truffleCallNode).isInliningForced();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.CallNodeHashCode)
    static int callNodeHashCode(Object truffleCallNode) {
        return ((TruffleCallNode)truffleCallNode).hashCode();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCompilableCallCount)
    static int getCompilableCallCount(Object compilableTruffleAST) {
        return ((CompilableTruffleAST)compilableTruffleAST).getCallCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetCallNodes)
    static Object[] getCallNodes(Object compilableTruffleAST) {
        return ((CompilableTruffleAST)compilableTruffleAST).getCallNodes();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetKnownCallSiteCount)
    static int getKnownCallSiteCount(Object compilableTruffleAST) {
        return ((CompilableTruffleAST)compilableTruffleAST).getKnownCallSiteCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsSameOrSplit)
    static boolean isSameOrSplit(Object compilableTruffleAST1, Object compilableTruffleAST2) {
        return ((CompilableTruffleAST)compilableTruffleAST1).isSameOrSplit((CompilableTruffleAST)compilableTruffleAST2);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.IsTrivial)
    static boolean isTrivial(Object compilableTruffleAST1) {
        return ((CompilableTruffleAST)compilableTruffleAST1).isTrivial();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetNonTrivialNodeCount)
    static int getNonTrivialNodeCount(Object compilableTruffleAST) {
        return ((CompilableTruffleAST)compilableTruffleAST).getNonTrivialNodeCount();
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AddTargetToDequeue)
    static void addTargetToDequeue(Object inliningPlan, Object compilableTruffleAST) {
        ((TruffleMetaAccessProvider)inliningPlan).addTargetToDequeue((CompilableTruffleAST)compilableTruffleAST);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.SetCallCount)
    static void setCallCount(Object inliningPlan, int count) {
        ((TruffleMetaAccessProvider)inliningPlan).setCallCount(count);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.SetInlinedCallCount)
    static void setInlinedCallCount(Object inliningPlan, int count) {
        ((TruffleMetaAccessProvider)inliningPlan).setInlinedCallCount(count);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.AddInlinedTarget)
    static void addInlinedTarget(Object inlining, Object target) {
        ((TruffleMetaAccessProvider)inlining).addInlinedTarget((CompilableTruffleAST)target);
    }

    @TruffleFromLibGraal(value=TruffleFromLibGraal.Id.GetThreadLocalPendingHandshakeOffset)
    static int getThreadLocalPendingHandshakeOffset(Object truffleRuntime) {
        return ((HotSpotTruffleCompilerRuntime)truffleRuntime).getThreadLocalPendingHandshakeOffset();
    }

    private static boolean checkHotSpotCalls() {
        EnumSet<TruffleFromLibGraal.Id> unimplemented = EnumSet.allOf(TruffleFromLibGraal.Id.class);
        for (Method method : TruffleFromLibGraalEntryPoints.class.getDeclaredMethods()) {
            TruffleFromLibGraal a;
            if (!Modifier.isStatic(method.getModifiers()) || (a = method.getAnnotation(TruffleFromLibGraal.class)) == null) continue;
            TruffleFromLibGraal.Id id = a.value();
            unimplemented.remove(id);
            TruffleFromLibGraalEntryPoints.check(id, id.getMethodName().equals(method.getName()), "Expected name \"%s\", got \"%s\"", id.getMethodName(), method.getName());
            TruffleFromLibGraalEntryPoints.check(id, id.getReturnType().equals(method.getReturnType()), "Expected return type %s, got %s", id.getReturnType().getName(), method.getReturnType().getName());
            TruffleFromLibGraalEntryPoints.checkParameters(id, method.getParameterTypes());
        }
        TruffleFromLibGraalEntryPoints.check(null, unimplemented.isEmpty(), "Missing implementations:%n%s", unimplemented.stream().map(TruffleFromLibGraalEntryPoints::missingImpl).sorted().collect(Collectors.joining(System.lineSeparator())));
        return true;
    }

    private static void checkParameters(TruffleFromLibGraal.Id id, Class<?>[] types) {
        Class<?>[] idTypes = id.getParameterTypes();
        TruffleFromLibGraalEntryPoints.check(id, idTypes.length == types.length, "Expected %d parameters, got %d", idTypes.length, types.length);
        for (int i = 0; i < types.length; ++i) {
            TruffleFromLibGraalEntryPoints.check(id, idTypes[i].equals(types[i]), "Parameter %d has wrong type, expected %s, got %s", i, idTypes[i].getName(), types[i].getName());
        }
    }

    private static String missingImpl(TruffleFromLibGraal.Id id) {
        Formatter buf = new Formatter();
        buf.format("    @%s(%s)%n", TruffleFromLibGraal.class.getSimpleName(), id.name());
        buf.format("    static %s %s(%s) {%n    }%n", id.getReturnType().getSimpleName(), id.getMethodName(), Stream.of(id.getParameterTypes()).map(c -> c.getSimpleName()).collect(Collectors.joining(", ")));
        return buf.toString();
    }

    private static void check(TruffleFromLibGraal.Id id, boolean condition, String format, Object ... args) {
        if (!condition) {
            String msg = String.format(format, args);
            if (id != null) {
                System.err.printf("ERROR: %s.%s: %s%n", TruffleFromLibGraalEntryPoints.class.getName(), id, msg);
            } else {
                System.err.printf("ERROR: %s: %s%n", TruffleFromLibGraalEntryPoints.class.getName(), msg);
            }
            System.exit(99);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !TruffleFromLibGraalEntryPoints.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !TruffleFromLibGraalEntryPoints.checkHotSpotCalls()) {
            throw new AssertionError();
        }
    }
}

