/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.cli.scriptui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.jsoup.Jsoup;
import org.phoenicis.scripts.ui.BrowserControl;
import org.phoenicis.scripts.ui.MenuItem;
import org.phoenicis.scripts.ui.Message;
import org.phoenicis.scripts.ui.ProgressControl;
import org.phoenicis.scripts.ui.SetupUi;

class SetupUiCliImplementation
implements SetupUi {
    private final boolean interactive;
    private final boolean verbose;

    SetupUiCliImplementation(String title, boolean interactive, boolean verbose) {
        this.interactive = interactive;
        this.verbose = verbose;
        this.printIfVerbose(title);
        this.printIfVerbose("-----------------");
    }

    public void setTopImage(File topImage) throws IOException {
    }

    public void setLeftImageText(String leftImageText) {
    }

    public void setTopImage(URL topImage) throws IOException {
    }

    public void showSimpleMessageStep(Message<Void> doneCallback, String textToShow) {
        this.printIfVerbose(textToShow);
        this.pauseIfInteractive();
        doneCallback.send(null);
    }

    public void showYesNoQuestionStep() {
        throw new UnsupportedOperationException("FIXME");
    }

    public void showTextBoxStep(Message<String> doneCallback, String textToShow, String defaultValue) {
        throw new UnsupportedOperationException("FIXME");
    }

    public void showMenuStep(Message<MenuItem> doneCallback, String textToShow, List<String> menuItems, String defaultValue) {
        throw new UnsupportedOperationException("FIXME");
    }

    public void showSpinnerStep(Message<Void> message, String textToShow) {
        this.printIfVerbose(textToShow);
        message.send(null);
    }

    public void showProgressBar(Message<ProgressControl> message, final String textToShow) {
        this.printIfVerbose(textToShow);
        message.send((Object)new ProgressControl(){
            private double percentage = 0.0;
            private String text = "";

            public void setProgressPercentage(double value) {
                this.percentage = Math.min(100.0, Math.max(0.0, value));
                SetupUiCliImplementation.this.printIfVerbose("[" + String.format("%.2f", this.percentage) + "] " + textToShow + " : " + this.text);
            }

            public void setText(String text) {
                this.text = text;
                SetupUiCliImplementation.this.printIfVerbose("[" + String.format("%.2f", this.percentage) + "] " + textToShow + " : " + text);
            }
        });
    }

    public void showBrowser(Message<BrowserControl> doneCallback, String textToShow) {
        throw new UnsupportedOperationException("CLI does not support browser");
    }

    public void showHtmlPresentationStep(Message<Void> doneCallback, String htmlToShow) {
        this.showSimpleMessageStep(doneCallback, Jsoup.parse((String)htmlToShow).text());
    }

    public void showPresentationStep(Message<Void> doneCallback, String textToShow) {
        this.showSimpleMessageStep(doneCallback, textToShow);
    }

    public void showLicenceStep(Message<Void> doneCallback, String textToShow, String licenceText) {
        throw new UnsupportedOperationException("FIXME");
    }

    public void showBrowseStep(Message<String> doneCallback, String textToShow, File browseDirectory, List<String> extensions) {
        throw new UnsupportedOperationException("FIXME");
    }

    public void close() {
    }

    private void printIfVerbose(String textToShow) {
        if (this.verbose) {
            System.out.println(textToShow);
        }
    }

    private void pause() {
        try {
            System.in.read();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void pauseIfInteractive() {
        if (this.interactive) {
            this.pause();
        }
    }
}

