/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.cli;

import com.github.jankroken.commandline.annotations.AllAvailableArguments;
import com.github.jankroken.commandline.annotations.LongSwitch;
import com.github.jankroken.commandline.annotations.Option;
import com.github.jankroken.commandline.annotations.ShortSwitch;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.graalvm.polyglot.Value;
import org.phoenicis.cli.CLIConfiguration;
import org.phoenicis.library.ShortcutRunner;
import org.phoenicis.multithreading.ControlledThreadPoolExecutorServiceCloser;
import org.phoenicis.repository.RepositoryManager;
import org.phoenicis.repository.dto.ScriptDTO;
import org.phoenicis.scripts.Installer;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class CLIController
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLIController.class);
    private final ConfigurableApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{CLIConfiguration.class});
    private final RepositoryManager repositoryManager = (RepositoryManager)this.applicationContext.getBean("repositoryManager", RepositoryManager.class);
    private final ScriptInterpreter scriptInterpreter = (ScriptInterpreter)this.applicationContext.getBean("scriptInterpreter", ScriptInterpreter.class);

    @Option
    @LongSwitch(value="run")
    @ShortSwitch(value="r")
    @AllAvailableArguments
    public void runApp(List<String> arguments) {
        String shortcutName = arguments.get(0);
        arguments.remove(0);
        ShortcutRunner shortcutRunner = (ShortcutRunner)this.applicationContext.getBean(ShortcutRunner.class);
        if (!shortcutRunner.shortcutExists(shortcutName)) {
            LOGGER.error("Requested shortcut does not exist: " + shortcutName);
            return;
        }
        shortcutRunner.run(shortcutName, arguments, e -> {
            throw new IllegalStateException((Throwable)e);
        });
    }

    @Option
    @LongSwitch(value="script")
    @ShortSwitch(value="s")
    @AllAvailableArguments
    public void runScript(List<String> arguments) {
        String scriptPath = arguments.get(0);
        File scriptFile = new File(scriptPath);
        ScriptInterpreter scriptInterpreter = (ScriptInterpreter)this.applicationContext.getBean("scriptInterpreter", ScriptInterpreter.class);
        scriptInterpreter.runScript(scriptFile, e -> {
            throw new IllegalStateException((Throwable)e);
        });
    }

    @Option
    @LongSwitch(value="install")
    @ShortSwitch(value="i")
    @AllAvailableArguments
    public void installApp(List<String> arguments) {
        String typeName;
        String typeId = typeName = arguments.get(0);
        String categoryName = arguments.get(1);
        String categoryId = typeId + "." + categoryName;
        String appName = arguments.get(2);
        String appId = categoryId + "." + appName;
        String scriptName = arguments.get(3);
        String scriptId = appId + "." + scriptName;
        ScriptDTO scriptDTO = this.repositoryManager.getScript(Arrays.asList(typeId, categoryId, appId, scriptId));
        if (scriptDTO == null) {
            LOGGER.error("Requested app does not exist: " + arguments);
            return;
        }
        StringBuilder executeBuilder = new StringBuilder();
        executeBuilder.append(String.format("TYPE_ID=\"%s\";\n", scriptDTO.getTypeId()));
        executeBuilder.append(String.format("CATEGORY_ID=\"%s\";\n", scriptDTO.getCategoryId()));
        executeBuilder.append(String.format("APPLICATION_ID=\"%s\";\n", scriptDTO.getApplicationId()));
        executeBuilder.append(String.format("SCRIPT_ID=\"%s\";\n", scriptDTO.getId()));
        executeBuilder.append(scriptDTO.getScript());
        executeBuilder.append("\n");
        this.scriptInterpreter.createInteractiveSession().eval(executeBuilder.toString(), result -> {
            Value installer = (Value)result;
            ((Installer)installer.as(Installer.class)).go();
        }, Throwable::printStackTrace);
    }

    @Override
    public void close() throws InterruptedException {
        ((ControlledThreadPoolExecutorServiceCloser)this.applicationContext.getBean(ControlledThreadPoolExecutorServiceCloser.class)).close();
        this.applicationContext.close();
    }
}

