/*
 * Decompiled with CFR 0.152.
 */
package com.github.jankroken.commandline.domain;

import com.github.jankroken.commandline.domain.ArgumentToken;
import com.github.jankroken.commandline.domain.SwitchToken;
import com.github.jankroken.commandline.domain.Token;
import com.github.jankroken.commandline.domain.Tokenizer;
import com.github.jankroken.commandline.util.PeekIterator;

public class SimpleTokenizer
implements Tokenizer {
    private PeekIterator<String> stringIterator;
    private boolean argumentEscapeEncountered = false;
    private String argumentTerminator = null;

    public SimpleTokenizer(PeekIterator<String> stringIterator) {
        this.stringIterator = stringIterator;
    }

    @Override
    public void setArgumentTerminator(String argumentTerminator) {
        this.argumentTerminator = argumentTerminator;
    }

    @Override
    public boolean hasNext() {
        return this.stringIterator.hasNext();
    }

    @Override
    public Token peek() {
        String value = this.stringIterator.peek();
        return this.makeToken(value);
    }

    @Override
    public Token next() {
        String value = this.stringIterator.next();
        return this.makeToken(value);
    }

    private Token makeToken(String value) {
        if (value.equals(this.argumentTerminator)) {
            this.argumentTerminator = null;
            return new ArgumentToken(value);
        }
        if (this.argumentTerminator != null) {
            return new ArgumentToken(value);
        }
        if (this.isArgumentEscape(value)) {
            this.argumentEscapeEncountered = true;
            return this.next();
        }
        if (!this.argumentEscapeEncountered && this.isSwitch(value)) {
            return new SwitchToken(value.substring(1), value);
        }
        return new ArgumentToken(value);
    }

    @Override
    public void remove() {
        this.stringIterator.remove();
    }

    private boolean isSwitch(String argument) {
        return argument.matches("-.*");
    }

    private boolean isArgumentEscape(String value) {
        return "--".equals(value) && !this.argumentEscapeEncountered;
    }
}

