/*
 * Decompiled with CFR 0.152.
 */
package com.github.jankroken.commandline.domain;

import com.github.jankroken.commandline.annotations.AllAvailableArguments;
import com.github.jankroken.commandline.annotations.ArgumentsUntilDelimiter;
import com.github.jankroken.commandline.annotations.LongSwitch;
import com.github.jankroken.commandline.annotations.LooseArguments;
import com.github.jankroken.commandline.annotations.Multiple;
import com.github.jankroken.commandline.annotations.Option;
import com.github.jankroken.commandline.annotations.Required;
import com.github.jankroken.commandline.annotations.ShortSwitch;
import com.github.jankroken.commandline.annotations.SingleArgument;
import com.github.jankroken.commandline.annotations.SubConfiguration;
import com.github.jankroken.commandline.annotations.Toggle;
import com.github.jankroken.commandline.domain.Occurrences;
import com.github.jankroken.commandline.domain.OptionSpecification;
import com.github.jankroken.commandline.domain.OptionSpecificationBuilder;
import com.github.jankroken.commandline.util.Methods;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class OptionSpecificationFactory {
    public static OptionSpecification getOptionSpecification(Object spec, Method method) {
        OptionSpecificationBuilder builder = new OptionSpecificationBuilder();
        builder.addMethod(method);
        builder.addConfiguration(spec);
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof Option) continue;
            if (annotation instanceof LongSwitch) {
                builder.addLongSwitch(((LongSwitch)annotation).value());
                continue;
            }
            if (annotation instanceof ShortSwitch) {
                builder.addShortSwitch(((ShortSwitch)annotation).value());
                continue;
            }
            if (annotation instanceof Toggle) {
                builder.addToggle(((Toggle)annotation).value());
                continue;
            }
            if (annotation instanceof SingleArgument) {
                builder.addSingleArgument();
                continue;
            }
            if (annotation instanceof AllAvailableArguments) {
                builder.addAllAvailableArguments();
                continue;
            }
            if (annotation instanceof ArgumentsUntilDelimiter) {
                builder.addUntilDelimiter(((ArgumentsUntilDelimiter)annotation).value());
                continue;
            }
            if (annotation instanceof SubConfiguration) {
                builder.addSubset(((SubConfiguration)annotation).value());
                continue;
            }
            if (annotation instanceof Required) {
                builder.addRequired();
                continue;
            }
            if (annotation instanceof Multiple) {
                builder.addOccurrences(Occurrences.MULTIPLE);
                continue;
            }
            if (annotation instanceof LooseArguments) {
                builder.addLooseArgs();
                continue;
            }
            System.out.println("Unhandled annotation: " + annotation);
        }
        return builder.getOptionSpecification();
    }

    public static List<OptionSpecification> getOptionSpecifications(Object spec, Class<?> optionClass) {
        List<Method> methods = new Methods(optionClass).byAnnotation(Option.class);
        ArrayList<OptionSpecification> optionSpecifications = new ArrayList<OptionSpecification>();
        for (Method method : methods) {
            optionSpecifications.add(OptionSpecificationFactory.getOptionSpecification(spec, method));
        }
        return optionSpecifications;
    }
}

