/*
 * Decompiled with CFR 0.152.
 */
package com.github.jankroken.commandline.domain;

import com.github.jankroken.commandline.domain.ArgumentConsumption;
import com.github.jankroken.commandline.domain.ArgumentConsumptionType;
import com.github.jankroken.commandline.domain.InternalErrorException;
import com.github.jankroken.commandline.domain.InvalidCommandLineException;
import com.github.jankroken.commandline.domain.InvalidOptionConfigurationException;
import com.github.jankroken.commandline.domain.Occurrences;
import com.github.jankroken.commandline.domain.OptionSet;
import com.github.jankroken.commandline.domain.OptionSetLevel;
import com.github.jankroken.commandline.domain.Switch;
import com.github.jankroken.commandline.domain.SwitchToken;
import com.github.jankroken.commandline.domain.Tokenizer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class OptionSpecification {
    private Method method;
    private boolean activated = false;
    private Switch _switch;
    private ArgumentConsumption argumentConsumption;
    private boolean required;
    private Occurrences occurrences;
    private Object spec;
    private ArrayList<Object> argumentBuffer = new ArrayList();

    public OptionSpecification(Object spec, Method method, Switch _switch, ArgumentConsumption argumentConsumption, boolean required, Occurrences occurences) {
        this.spec = spec;
        this._switch = _switch;
        this.method = method;
        this.argumentConsumption = argumentConsumption;
        this.required = required;
        this.occurrences = occurences;
        this.validate();
    }

    public boolean isLooseArgumentsSpecification() {
        return this.argumentConsumption.getType() == ArgumentConsumptionType.LOOSE_ARGS;
    }

    public void validate() {
        if (this.argumentConsumption.getType() != ArgumentConsumptionType.LOOSE_ARGS && (this._switch == null || this._switch.getShortSwitch() == null && this._switch.getLongSwitch() == null)) {
            throw this.createInvalidOptionSpecificationException("Option specified without switchess");
        }
        this.validateType();
    }

    private void validateType() {
        Type[] types = this.method.getGenericParameterTypes();
        if (types == null || types.length != 1) {
            throw this.createInvalidOptionSpecificationException("Wrong number of arguments, expecting exactly one");
        }
        Type type = types[0];
        int listLevel = this.getListLevel();
        this.verifyType(listLevel, this.getInnerArgumentType(), type, type);
    }

    private void verifyType(int listLevel, Class<?> innerClass, Type type, Type fullType) {
        if (listLevel > 0) {
            if (!this.toClass(type).isAssignableFrom(List.class)) {
                this.wrongType(fullType);
            } else {
                Type innerType = ((ParameterizedType)type).getActualTypeArguments()[0];
                this.verifyType(listLevel - 1, innerClass, innerType, fullType);
            }
        } else if (!this.box(this.toClass(type)).isAssignableFrom(innerClass)) {
            this.wrongType(fullType);
        }
    }

    private Class toClass(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        throw this.createInternalErrorException("Don't know how to get the class from type " + type);
    }

    private Class<?> box(Class<?> rawClass) {
        if (rawClass == Boolean.TYPE) {
            return Boolean.class;
        }
        return rawClass;
    }

    private void wrongType(Type type) {
        throw this.createInvalidOptionSpecificationException("Wrong argument type, expected " + this.getExpectedTypeDescription() + " but found " + type);
    }

    private String getExpectedTypeDescription() {
        int i;
        StringBuilder sb = new StringBuilder();
        int listLevel = this.getListLevel();
        for (i = 0; i < listLevel; ++i) {
            sb.append("List<");
        }
        sb.append(this.getInnerArgumentType());
        for (i = 0; i < listLevel; ++i) {
            sb.append(">");
        }
        return sb.toString();
    }

    private int getListLevel() {
        int listLevel = 0;
        if (this.occurrences == Occurrences.MULTIPLE) {
            ++listLevel;
        }
        switch (this.argumentConsumption.getType()) {
            case NO_ARGS: 
            case SINGLE_ARGUMENT: 
            case SUB_SET: {
                break;
            }
            case ALL_AVAILABLE: 
            case UNTIL_DELIMITER: {
                ++listLevel;
            }
        }
        return listLevel;
    }

    private Class<?> getInnerArgumentType() {
        switch (this.argumentConsumption.getType()) {
            case NO_ARGS: {
                return Boolean.class;
            }
            case SINGLE_ARGUMENT: {
                return String.class;
            }
            case SUB_SET: {
                return this.argumentConsumption.getSubsetClass();
            }
            case ALL_AVAILABLE: {
                return String.class;
            }
            case UNTIL_DELIMITER: {
                return String.class;
            }
            case LOOSE_ARGS: {
                return String.class;
            }
        }
        throw new RuntimeException("Internal error");
    }

    public Switch getSwitch() {
        return this._switch;
    }

    public void activateAndConsumeArguments(Tokenizer args) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        this.activated = true;
        switch (this.argumentConsumption.getType()) {
            case NO_ARGS: {
                this.handleArguments(this.argumentConsumption.getToggleValue());
                break;
            }
            case SINGLE_ARGUMENT: {
                if (!args.hasNext() || args.peek() instanceof SwitchToken) {
                    throw this.createInvalidCommandLineException("Missing argument");
                }
                String argument = args.next().getValue();
                this.handleArguments(argument);
                break;
            }
            case ALL_AVAILABLE: {
                ArrayList<String> allArguments = new ArrayList<String>();
                while (args.hasNext() && !(args.peek() instanceof SwitchToken)) {
                    allArguments.add(args.next().getValue());
                }
                this.handleArguments(allArguments);
                break;
            }
            case UNTIL_DELIMITER: {
                args.setArgumentTerminator(this.argumentConsumption.getDelimiter());
                ArrayList<String> delimitedArguments = new ArrayList<String>();
                while (args.hasNext() && !args.peek().getValue().equals(this.argumentConsumption.getDelimiter())) {
                    delimitedArguments.add(args.next().getArgumentValue());
                }
                if (args.hasNext()) {
                    args.next();
                }
                this.handleArguments(delimitedArguments);
                break;
            }
            case SUB_SET: {
                Object subset = this.argumentConsumption.getSubsetClass().newInstance();
                OptionSet subsetOptions = new OptionSet(subset, OptionSetLevel.SUB_GROUP);
                subsetOptions.consumeOptions(args);
                this.handleArguments(subset);
                break;
            }
            case LOOSE_ARGS: {
                this.handleArguments(args.next().getValue());
                break;
            }
            default: {
                throw this.createInternalErrorException("Not implemented: " + (Object)((Object)this.argumentConsumption.getType()));
            }
        }
    }

    private void handleArguments(Object args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.occurrences == Occurrences.SINGLE) {
            this.method.invoke(this.spec, args);
        } else {
            this.argumentBuffer.add(args);
        }
    }

    public void flush() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.required && !this.activated) {
            throw this.createInvalidCommandLineException("Required argument not specified");
        }
        if (this.occurrences == Occurrences.MULTIPLE) {
            this.method.invoke(this.spec, this.argumentBuffer);
        }
    }

    private InvalidOptionConfigurationException createInvalidOptionSpecificationException(String description) {
        return new InvalidOptionConfigurationException(this.getOptionId() + ' ' + description);
    }

    private InvalidCommandLineException createInvalidCommandLineException(String description) {
        return new InvalidCommandLineException(this.getOptionId() + ' ' + description);
    }

    private RuntimeException createInternalErrorException(String description) {
        return new InternalErrorException(this.getOptionId() + ' ' + description);
    }

    public String getOptionId() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.spec.getClass().getName()).append(":").append(this.method.getName()).append("]");
        return sb.toString();
    }
}

