/*
 * Decompiled with CFR 0.152.
 */
package com.github.jankroken.commandline.domain;

import com.github.jankroken.commandline.domain.InvalidCommandLineException;
import com.github.jankroken.commandline.domain.OptionSetLevel;
import com.github.jankroken.commandline.domain.OptionSpecification;
import com.github.jankroken.commandline.domain.OptionSpecificationFactory;
import com.github.jankroken.commandline.domain.SwitchToken;
import com.github.jankroken.commandline.domain.Tokenizer;
import com.github.jankroken.commandline.domain.UnrecognizedSwitchException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class OptionSet {
    private List<OptionSpecification> options;
    private OptionSetLevel optionSetLevel;
    private Object spec;

    public OptionSet(Object spec, OptionSetLevel optionSetLevel) {
        this.options = OptionSpecificationFactory.getOptionSpecifications(spec, spec.getClass());
        this.optionSetLevel = optionSetLevel;
        this.spec = spec;
    }

    public OptionSpecification getOptionSpecification(SwitchToken _switch) {
        for (OptionSpecification optionSpecification : this.options) {
            if (!optionSpecification.getSwitch().matches(_switch.getValue())) continue;
            return optionSpecification;
        }
        return null;
    }

    public OptionSpecification getLooseArgsOptionSpecification() {
        for (OptionSpecification optionSpecification : this.options) {
            if (!optionSpecification.isLooseArgumentsSpecification()) continue;
            return optionSpecification;
        }
        return null;
    }

    public void consumeOptions(Tokenizer args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        while (args.hasNext()) {
            if (args.peek() instanceof SwitchToken) {
                OptionSpecification optionSpecification = this.getOptionSpecification((SwitchToken)args.peek());
                if (optionSpecification == null) {
                    switch (this.optionSetLevel) {
                        case MAIN_OPTIONS: {
                            throw new UnrecognizedSwitchException(this.spec.getClass(), args.peek().getValue());
                        }
                        case SUB_GROUP: {
                            this.validateAndConsolidate();
                            return;
                        }
                    }
                    continue;
                }
                args.next();
                optionSpecification.activateAndConsumeArguments(args);
                continue;
            }
            OptionSpecification looseArgsOptionSpecification = this.getLooseArgsOptionSpecification();
            if (looseArgsOptionSpecification != null) {
                looseArgsOptionSpecification.activateAndConsumeArguments(args);
                continue;
            }
            switch (this.optionSetLevel) {
                case MAIN_OPTIONS: {
                    throw new InvalidCommandLineException("Invalid argument: " + args.peek());
                }
                case SUB_GROUP: {
                    this.validateAndConsolidate();
                    return;
                }
            }
        }
        this.flush();
    }

    private void flush() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (OptionSpecification option : this.options) {
            option.flush();
        }
    }

    public void validateAndConsolidate() {
    }
}

