/*
 * Decompiled with CFR 0.152.
 */
package com.github.jankroken.commandline.domain;

import com.github.jankroken.commandline.domain.ArgumentToken;
import com.github.jankroken.commandline.domain.SwitchToken;
import com.github.jankroken.commandline.domain.Token;
import com.github.jankroken.commandline.domain.Tokenizer;
import com.github.jankroken.commandline.util.PeekIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class LongOrCompactTokenizer
implements Tokenizer {
    private PeekIterator<String> stringIterator;
    private boolean argumentEscapeEncountered = false;
    private String argumentTerminator = null;
    private LinkedList<SwitchToken> splitTokens = new LinkedList();

    public LongOrCompactTokenizer(PeekIterator<String> stringIterator) {
        this.stringIterator = stringIterator;
    }

    @Override
    public void setArgumentTerminator(String argumentTerminator) {
        this.argumentTerminator = argumentTerminator;
    }

    @Override
    public boolean hasNext() {
        return this.stringIterator.hasNext();
    }

    @Override
    public Token peek() {
        if (!this.splitTokens.isEmpty()) {
            return this.splitTokens.peek();
        }
        String value = this.stringIterator.peek();
        if (this.argumentEscapeEncountered) {
            return new ArgumentToken(value);
        }
        if (value.equals(this.argumentTerminator)) {
            return new ArgumentToken(value);
        }
        if (this.argumentTerminator != null) {
            return new ArgumentToken(value);
        }
        if (this.isArgumentEscape(value)) {
            this.argumentEscapeEncountered = true;
            return this.peek();
        }
        if (this.isSwitch(value)) {
            if (this.isShortSwitchList(value)) {
                List<SwitchToken> tokens = this.splitSwitchTokens(value);
                return tokens.get(0);
            }
            return new SwitchToken(value.substring(2), value);
        }
        return new ArgumentToken(value);
    }

    @Override
    public Token next() {
        if (!this.splitTokens.isEmpty()) {
            return this.splitTokens.remove();
        }
        String value = this.stringIterator.next();
        if (this.argumentEscapeEncountered) {
            return new ArgumentToken(value);
        }
        if (value.equals(this.argumentTerminator)) {
            this.argumentTerminator = null;
            return new ArgumentToken(value);
        }
        if (this.argumentTerminator != null) {
            return new ArgumentToken(value);
        }
        if (this.isArgumentEscape(value)) {
            this.argumentEscapeEncountered = true;
            return this.next();
        }
        if (this.isSwitch(value)) {
            if (this.isShortSwitchList(value)) {
                this.splitTokens.addAll(this.splitSwitchTokens(value));
                return this.splitTokens.remove();
            }
            return new SwitchToken(value.substring(2), value);
        }
        return new ArgumentToken(value);
    }

    @Override
    public void remove() {
        this.stringIterator.remove();
    }

    private boolean isSwitch(String argument) {
        return argument.matches("-.*");
    }

    private boolean isArgumentEscape(String value) {
        return "--".equals(value) && !this.argumentEscapeEncountered;
    }

    private boolean isLongSwitch(String value) {
        return value.matches("--..*");
    }

    private boolean isShortSwitchList(String value) {
        return value.matches("-[^-].*");
    }

    private List<SwitchToken> splitSwitchTokens(String value) {
        ArrayList<SwitchToken> tokens = new ArrayList<SwitchToken>();
        for (int i = 1; i < value.length(); ++i) {
            tokens.add(new SwitchToken(String.valueOf(value.charAt(i)), value));
        }
        return tokens;
    }
}

