/*
 * Decompiled with CFR 0.152.
 */
package com.github.jankroken.commandline.domain;

import com.github.jankroken.commandline.domain.ArgumentConsumption;
import com.github.jankroken.commandline.domain.ArgumentConsumptionType;
import com.github.jankroken.commandline.domain.InternalErrorException;
import com.github.jankroken.commandline.domain.InvalidOptionConfigurationException;

public class ArgumentConsumptionBuilder {
    private boolean no_arguments = false;
    private boolean toggle_value = false;
    private boolean single_argument = false;
    private boolean until_delimiter = false;
    private boolean all_available = false;
    private boolean sub_set = false;
    private boolean loose_args = false;
    private String delimiter = null;
    private Class<?> subsetClass = null;

    public void addNoArgs(boolean value) {
        this.no_arguments = true;
        this.toggle_value = value;
    }

    public void addSingleArgument() {
        this.single_argument = true;
    }

    public void addUntilDelimiter(String delimiter) {
        this.until_delimiter = true;
        this.delimiter = delimiter;
    }

    public void addAllAvailable() {
        this.all_available = true;
    }

    public void addLooseArgs() {
        this.loose_args = true;
    }

    public void addSubSet(Class<?> subsetClass) {
        this.sub_set = true;
        this.subsetClass = subsetClass;
    }

    public ArgumentConsumption getArgumentConsumption() {
        int argumentConsumptionTypeCounter = 0;
        if (this.no_arguments) {
            ++argumentConsumptionTypeCounter;
        }
        if (this.single_argument) {
            ++argumentConsumptionTypeCounter;
        }
        if (this.until_delimiter) {
            ++argumentConsumptionTypeCounter;
        }
        if (this.all_available) {
            ++argumentConsumptionTypeCounter;
        }
        if (this.sub_set) {
            ++argumentConsumptionTypeCounter;
        }
        if (this.loose_args) {
            ++argumentConsumptionTypeCounter;
        }
        if (argumentConsumptionTypeCounter == 0) {
            throw new InvalidOptionConfigurationException("No argument consumption type specified");
        }
        if (argumentConsumptionTypeCounter > 1) {
            throw new InvalidOptionConfigurationException("Multiple argument consumption types specified");
        }
        if (this.no_arguments) {
            return new ArgumentConsumption(ArgumentConsumptionType.NO_ARGS, this.toggle_value);
        }
        if (this.single_argument) {
            return new ArgumentConsumption(ArgumentConsumptionType.SINGLE_ARGUMENT);
        }
        if (this.until_delimiter) {
            return new ArgumentConsumption(ArgumentConsumptionType.UNTIL_DELIMITER, this.delimiter);
        }
        if (this.all_available) {
            return new ArgumentConsumption(ArgumentConsumptionType.ALL_AVAILABLE);
        }
        if (this.sub_set) {
            return new ArgumentConsumption(ArgumentConsumptionType.SUB_SET, this.subsetClass);
        }
        if (this.loose_args) {
            return new ArgumentConsumption(ArgumentConsumptionType.LOOSE_ARGS);
        }
        throw new InternalErrorException("Internal error: no matching argument consumption types");
    }
}

