/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonDeserialize(builder=Builder.class)
public class EngineVersionDTO {
    private final String version;
    private final String url;
    private final String sha1sum;
    private final String geckoUrl;
    private final String geckoMd5;
    private final String monoUrl;
    private final String monoMd5;
    private final String monoFile;
    private final String geckoFile;

    private EngineVersionDTO(Builder builder) {
        this.version = builder.version;
        this.url = builder.url;
        this.sha1sum = builder.sha1sum;
        this.geckoUrl = builder.geckoUrl;
        this.geckoMd5 = builder.geckoMd5;
        this.monoUrl = builder.monoUrl;
        this.monoMd5 = builder.monoMd5;
        this.monoFile = builder.monoFile;
        this.geckoFile = builder.geckoFile;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSha1sum() {
        return this.sha1sum;
    }

    public String getGeckoMd5() {
        return this.geckoMd5;
    }

    public String getGeckoUrl() {
        return this.geckoUrl;
    }

    public String getMonoMd5() {
        return this.monoMd5;
    }

    public String getMonoUrl() {
        return this.monoUrl;
    }

    public String getMonoFile() {
        return this.monoFile;
    }

    public String getGeckoFile() {
        return this.geckoFile;
    }

    public String toString() {
        return new ToStringBuilder(EngineVersionDTO.class).append("version", (Object)this.version).append("url", (Object)this.url).append("sha1sum", (Object)this.sha1sum).append("geckoUrl", (Object)this.geckoUrl).append("geckoMd5", (Object)this.geckoMd5).append("monoUrl", (Object)this.monoUrl).append("monoMd5", (Object)this.monoMd5).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineVersionDTO that = (EngineVersionDTO)o;
        return new EqualsBuilder().append((Object)this.version, (Object)that.version).append((Object)this.url, (Object)that.url).append((Object)this.sha1sum, (Object)that.sha1sum).append((Object)this.geckoUrl, (Object)that.geckoUrl).append((Object)this.geckoMd5, (Object)that.geckoMd5).append((Object)this.monoUrl, (Object)that.monoUrl).append((Object)this.monoMd5, (Object)that.monoMd5).append((Object)this.monoFile, (Object)that.monoFile).append((Object)this.geckoFile, (Object)that.geckoFile).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.version).append((Object)this.url).append((Object)this.sha1sum).append((Object)this.geckoUrl).append((Object)this.geckoMd5).append((Object)this.monoUrl).append((Object)this.monoMd5).append((Object)this.monoFile).append((Object)this.geckoFile).toHashCode();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String version;
        private String url;
        private String sha1sum;
        private String geckoUrl;
        private String geckoMd5;
        private String monoUrl;
        private String monoMd5;
        private String monoFile;
        private String geckoFile;

        public Builder withGeckoMd5(String geckoMd5) {
            this.geckoMd5 = geckoMd5;
            return this;
        }

        public Builder withGeckoUrl(String geckoUrl) {
            this.geckoUrl = geckoUrl;
            return this;
        }

        public Builder withMonoMd5(String monoMd5) {
            this.monoMd5 = monoMd5;
            return this;
        }

        public Builder withMonoUrl(String monoUrl) {
            this.monoUrl = monoUrl;
            return this;
        }

        public Builder withSha1sum(String sha1sum) {
            this.sha1sum = sha1sum;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withMonoFile(String monoFile) {
            this.monoFile = monoFile;
            return this;
        }

        public Builder withGeckoFile(String geckoFile) {
            this.geckoFile = geckoFile;
            return this;
        }

        public EngineVersionDTO build() {
            return new EngineVersionDTO(this);
        }
    }
}

