/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.engines.dto.EngineVersionDTO;
import org.phoenicis.tools.version.Version;
import org.phoenicis.tools.version.VersionComparator;

public class EngineSubCategoryDTO {
    private final String name;
    private final String description;
    private final List<EngineVersionDTO> packages;

    @JsonCreator
    public EngineSubCategoryDTO(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="packages") List<EngineVersionDTO> packages) {
        this.name = name;
        this.description = description;
        this.packages = packages;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public List<EngineVersionDTO> getPackages() {
        return this.packages;
    }

    public String toString() {
        return new ToStringBuilder(EngineSubCategoryDTO.class).append("name", (Object)this.name).append("description", (Object)this.description).append("packages", this.packages).toString();
    }

    public static Comparator<EngineVersionDTO> comparator() {
        return (o1, o2) -> new VersionComparator().compare(new Version(o1.getVersion()), new Version(o2.getVersion()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineSubCategoryDTO that = (EngineSubCategoryDTO)o;
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).append((Object)this.description, (Object)that.description).append(this.packages, that.packages).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.description).append(this.packages).toHashCode();
    }
}

