/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonDeserialize(builder=Builder.class)
public class EngineDTO {
    private final String category;
    private final String subCategory;
    private final String version;
    private final Map<String, String> userData;

    private EngineDTO(Builder builder) {
        this.category = builder.category;
        this.subCategory = builder.subCategory;
        this.version = builder.version;
        this.userData = builder.userData;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getVersion() {
        return this.version;
    }

    public String getId() {
        return this.category.toLowerCase();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public String toString() {
        return new ToStringBuilder(EngineDTO.class).append("category", (Object)this.category).append("subCategory", (Object)this.subCategory).append("version", (Object)this.version).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineDTO engineDTO = (EngineDTO)o;
        return new EqualsBuilder().append((Object)this.category, (Object)engineDTO.category).append((Object)this.subCategory, (Object)engineDTO.subCategory).append((Object)this.version, (Object)engineDTO.version).append(this.userData, engineDTO.userData).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.category).append((Object)this.subCategory).append((Object)this.version).append(this.userData).toHashCode();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String category;
        private String subCategory;
        private String version;
        private Map<String, String> userData;

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withSubCategory(String distribution) {
            this.subCategory = distribution;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withUserData(Map<String, String> userData) {
            this.userData = userData;
            return this;
        }

        public EngineDTO build() {
            return new EngineDTO(this);
        }
    }
}

