/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.engines.dto.EngineSubCategoryDTO;

@JsonDeserialize(builder=Builder.class)
public class EngineCategoryDTO {
    private final String name;
    private final String description;
    private final List<EngineSubCategoryDTO> subCategories;
    private final URI icon;

    private EngineCategoryDTO(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.subCategories = Collections.unmodifiableList(builder.subCategories);
        this.icon = builder.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EngineSubCategoryDTO> getSubCategories() {
        return this.subCategories;
    }

    public URI getIcon() {
        return this.icon;
    }

    public static Comparator<EngineCategoryDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineCategoryDTO that = (EngineCategoryDTO)o;
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).append((Object)this.description, (Object)that.description).append(this.subCategories, that.subCategories).append((Object)this.icon, (Object)that.icon).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.description).append(this.subCategories).append((Object)this.icon).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).toString();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String name;
        private String description;
        private List<EngineSubCategoryDTO> subCategories = new ArrayList<EngineSubCategoryDTO>();
        private URI icon;

        public Builder() {
        }

        public Builder(EngineCategoryDTO categoryDTO) {
            this.withName(categoryDTO.getName()).withDescription(categoryDTO.getDescription()).withSubCategories(categoryDTO.getSubCategories()).withIcon(categoryDTO.getIcon());
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withSubCategories(List<EngineSubCategoryDTO> subCategories) {
            this.subCategories = subCategories;
            return this;
        }

        public Builder withIcon(URI iconPath) {
            this.icon = iconPath;
            return this;
        }

        public EngineCategoryDTO build() {
            return new EngineCategoryDTO(this);
        }
    }
}

