/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.graalvm.polyglot.Value;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.dto.TypeDTO;
import org.phoenicis.scripts.exceptions.ScriptException;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.session.InteractiveScriptSession;

public class VerbsManager {
    private final ScriptInterpreter scriptInterpreter;

    public VerbsManager(ScriptInterpreter scriptInterpreter) {
        this.scriptInterpreter = scriptInterpreter;
    }

    public void installVerb(String engineId, String container, String verbId, Runnable doneCallback, Consumer<Exception> errorCallback) {
        InteractiveScriptSession interactiveScriptSession = this.scriptInterpreter.createInteractiveSession();
        String script = String.format("include(\"%s\");", verbId);
        interactiveScriptSession.eval(script, output -> {
            Value verbClass = (Value)output;
            try {
                verbClass.invokeMember("install", new Object[]{container});
            }
            catch (ScriptException se) {
                errorCallback.accept((Exception)((Object)se));
            }
            doneCallback.run();
        }, errorCallback);
    }

    public void installVerbs(String engineId, String container, List<String> verbIds, Runnable doneCallback, Consumer<Exception> errorCallback) {
        if (verbIds.isEmpty()) {
            doneCallback.run();
        } else {
            String verbId = verbIds.get(0);
            List<String> remainingVerbIds = verbIds.subList(1, verbIds.size());
            this.installVerb(engineId, container, verbId, () -> this.installVerbs(engineId, container, remainingVerbIds, doneCallback, errorCallback), errorCallback);
        }
    }

    public void fetchAvailableVerbs(RepositoryDTO repositoryDTO, Consumer<Map<String, ApplicationDTO>> callback) {
        HashMap<String, ApplicationDTO> verbs = new HashMap<String, ApplicationDTO>();
        List categoryDTOS = new ArrayList();
        for (TypeDTO typeDTO : repositoryDTO.getTypes()) {
            if (!typeDTO.getId().equals("engines")) continue;
            categoryDTOS = typeDTO.getCategories();
        }
        for (CategoryDTO engine : categoryDTOS) {
            for (ApplicationDTO applicationDTO : engine.getApplications()) {
                if (!applicationDTO.getId().equals(engine.getId() + ".verbs")) continue;
                verbs.put(engine.getId().replaceAll("^.*\\.", ""), applicationDTO);
            }
        }
        callback.accept(verbs);
    }
}

