/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Value;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.engines.Engine;
import org.phoenicis.engines.dto.EngineCategoryDTO;
import org.phoenicis.engines.dto.EngineSubCategoryDTO;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.scripts.engine.PhoenicisScriptEngineFactory;
import org.phoenicis.scripts.engine.implementation.PhoenicisScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Safe
public class EnginesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnginesManager.class);
    private final PhoenicisScriptEngineFactory phoenicisScriptEngineFactory;
    private final ExecutorService executorService;
    private final ObjectMapper objectMapper;

    public EnginesManager(PhoenicisScriptEngineFactory phoenicisScriptEngineFactory, ExecutorService executorService, ObjectMapper objectMapper) {
        this.phoenicisScriptEngineFactory = phoenicisScriptEngineFactory;
        this.executorService = executorService;
        this.objectMapper = objectMapper;
    }

    public void getEngine(String engineId, Consumer<Engine> doneCallback, Consumer<Exception> errorCallback) {
        this.executorService.execute(() -> {
            PhoenicisScriptEngine phoenicisScriptEngine = this.phoenicisScriptEngineFactory.createEngine();
            String include = String.format("include(\"engines.%s.engine.implementation\");", engineId);
            Value engineClass = (Value)phoenicisScriptEngine.evalAndReturn(include, errorCallback);
            Engine engine = (Engine)engineClass.newInstance(new Object[0]).as(Engine.class);
            doneCallback.accept(engine);
        });
    }

    public void fetchAvailableVersions(String engineId, Consumer<List<EngineSubCategoryDTO>> callback, Consumer<Exception> errorCallback) {
        this.getEngine(engineId, engine -> callback.accept(this.deserialize(engine.getAvailableVersions())), errorCallback);
    }

    public List<EngineCategoryDTO> getAvailableEngines(List<CategoryDTO> categoryDTOS) {
        return categoryDTOS.stream().map(category -> {
            String engineName = category.getName();
            return new EngineCategoryDTO.Builder().withName(engineName).withDescription(engineName).withSubCategories(new ArrayList<EngineSubCategoryDTO>()).build();
        }).collect(Collectors.toList());
    }

    private List<EngineSubCategoryDTO> deserialize(Object json) {
        try {
            return (List)this.objectMapper.readValue(json.toString(), (TypeReference)new TypeReference<List<EngineSubCategoryDTO>>(){});
        }
        catch (IOException e) {
            LOGGER.debug("Unable to deserialize engine json");
            return Collections.emptyList();
        }
    }

    public void fetchAvailableEngines(RepositoryDTO repositoryDTO, Consumer<Map<String, Engine>> callback, Consumer<Exception> errorCallback) {
        List engineIds = repositoryDTO.getTypes().stream().filter(type -> type.getId().equals("engines")).flatMap(type -> type.getCategories().stream()).map(engine -> engine.getId().replaceAll("^.*\\.", "")).collect(Collectors.toList());
        this.executorService.execute(() -> {
            PhoenicisScriptEngine phoenicisScriptEngine = this.phoenicisScriptEngineFactory.createEngine();
            Map result = engineIds.stream().collect(Collectors.toMap(Function.identity(), engineId -> {
                String include = String.format("include(\"engines.%s.engine.implementation\");", engineId);
                Value engineClass = (Value)phoenicisScriptEngine.evalAndReturn(include, errorCallback);
                return (Engine)engineClass.newInstance(new Object[0]).as(Engine.class);
            }));
            callback.accept(result);
        });
    }
}

