/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines;

import java.util.concurrent.ExecutorService;
import org.phoenicis.configuration.PhoenicisGlobalConfiguration;
import org.phoenicis.engines.EngineSettingsManager;
import org.phoenicis.engines.EngineToolsManager;
import org.phoenicis.engines.EnginesManager;
import org.phoenicis.engines.VerbsManager;
import org.phoenicis.multithreading.MultithreadingConfiguration;
import org.phoenicis.scripts.ScriptsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EnginesConfiguration {
    @Autowired
    private ScriptsConfiguration scriptsConfiguration;
    @Autowired
    private PhoenicisGlobalConfiguration phoenicisGlobalConfiguration;
    @Autowired
    private MultithreadingConfiguration multithreadingConfiguration;

    @Bean
    public EnginesManager enginesSource() {
        return new EnginesManager(this.scriptsConfiguration.graalScriptEngineFactory(), (ExecutorService)this.multithreadingConfiguration.scriptExecutorService(), this.phoenicisGlobalConfiguration.objectMapper());
    }

    @Bean
    public EngineSettingsManager engineSettingsManager() {
        return new EngineSettingsManager(this.scriptsConfiguration.graalScriptEngineFactory(), (ExecutorService)this.multithreadingConfiguration.scriptExecutorService());
    }

    @Bean
    public VerbsManager verbsManager() {
        return new VerbsManager(this.scriptsConfiguration.scriptInterpreter());
    }

    @Bean
    public EngineToolsManager engineToolsManager() {
        return new EngineToolsManager(this.scriptsConfiguration.scriptInterpreter());
    }
}

