/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.graalvm.polyglot.Value;
import org.phoenicis.engines.EngineTool;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.CategoryDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.repository.dto.TypeDTO;
import org.phoenicis.scripts.interpreter.ScriptInterpreter;
import org.phoenicis.scripts.session.InteractiveScriptSession;

public class EngineToolsManager {
    private final ScriptInterpreter scriptInterpreter;

    public EngineToolsManager(ScriptInterpreter scriptInterpreter) {
        this.scriptInterpreter = scriptInterpreter;
    }

    public void runTool(String engineId, String container, String toolId, Runnable doneCallback, Consumer<Exception> errorCallback) {
        InteractiveScriptSession interactiveScriptSession = this.scriptInterpreter.createInteractiveSession();
        String include = String.format("include(\"engines.%s.tools.%s\");", engineId, toolId);
        interactiveScriptSession.eval(include, output -> {
            Value toolClass = (Value)output;
            EngineTool tool = (EngineTool)toolClass.newInstance(new Object[0]).as(EngineTool.class);
            tool.run(container);
            doneCallback.run();
        }, errorCallback);
    }

    public void fetchAvailableEngineTools(RepositoryDTO repositoryDTO, Consumer<Map<String, ApplicationDTO>> callback) {
        List categoryDTOS = new ArrayList();
        for (TypeDTO typeDTO : repositoryDTO.getTypes()) {
            if (!typeDTO.getId().equals("engines")) continue;
            categoryDTOS = typeDTO.getCategories();
        }
        HashMap<String, ApplicationDTO> tools = new HashMap<String, ApplicationDTO>();
        for (CategoryDTO engine : categoryDTOS) {
            for (ApplicationDTO applicationDTO : engine.getApplications()) {
                if (!applicationDTO.getId().equals(engine.getId() + ".tools")) continue;
                tools.put(engine.getId().replaceAll("^.*\\.", ""), applicationDTO);
            }
        }
        callback.accept(tools);
    }
}

