/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.engines;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.graalvm.polyglot.Value;
import org.phoenicis.engines.EngineSetting;
import org.phoenicis.repository.dto.ApplicationDTO;
import org.phoenicis.repository.dto.RepositoryDTO;
import org.phoenicis.scripts.engine.PhoenicisScriptEngineFactory;
import org.phoenicis.scripts.engine.implementation.PhoenicisScriptEngine;

public class EngineSettingsManager {
    private final PhoenicisScriptEngineFactory phoenicisScriptEngineFactory;
    private final ExecutorService executorService;

    public EngineSettingsManager(PhoenicisScriptEngineFactory phoenicisScriptEngineFactory, ExecutorService executorService) {
        this.phoenicisScriptEngineFactory = phoenicisScriptEngineFactory;
        this.executorService = executorService;
    }

    public void fetchAvailableEngineSettings(RepositoryDTO repositoryDTO, Consumer<Map<String, List<EngineSetting>>> callback, Consumer<Exception> errorCallback) {
        this.executorService.execute(() -> {
            List<SettingConfig> configurations = this.fetchSettingConfigurations(repositoryDTO);
            PhoenicisScriptEngine phoenicisScriptEngine = this.phoenicisScriptEngineFactory.createEngine();
            Map result = configurations.stream().collect(Collectors.groupingBy(configuration -> configuration.engineId, Collectors.mapping(configuration -> {
                String include = String.format("include(\"engines.%s.settings.%s\");", configuration.engineId, configuration.settingId);
                Value settingClass = (Value)phoenicisScriptEngine.evalAndReturn(include, errorCallback);
                return (EngineSetting)settingClass.newInstance(new Object[0]).as(EngineSetting.class);
            }, Collectors.toList())));
            callback.accept(result);
        });
    }

    private List<SettingConfig> fetchSettingConfigurations(RepositoryDTO repositoryDTO) {
        List categoryDTOs = repositoryDTO.getTypes().stream().filter(typeDTO -> typeDTO.getId().equals("engines")).flatMap(typeDTO -> typeDTO.getCategories().stream()).collect(Collectors.toList());
        return categoryDTOs.stream().flatMap(engine -> {
            String engineId = engine.getId().replaceAll("^.*\\.", "");
            return engine.getApplications().stream().map(application -> new EngineInformation(engineId, (ApplicationDTO)application));
        }).filter(engineInformation -> {
            String applicationId = engineInformation.application.getId();
            String settingIdPrefix = String.format("engines.%s.settings", engineInformation.engineId);
            return applicationId.equals(settingIdPrefix);
        }).flatMap(engineInformation -> engineInformation.application.getScripts().stream().map(script -> {
            String settingId = script.getId().replaceAll("^.*\\.", "");
            return new SettingConfig(engineInformation.engineId, settingId);
        })).collect(Collectors.toList());
    }

    private class SettingConfig {
        public final String engineId;
        public final String settingId;

        public SettingConfig(String engineId, String settingId) {
            this.engineId = engineId;
            this.settingId = settingId;
        }
    }

    private class EngineInformation {
        public final String engineId;
        public final ApplicationDTO application;

        private EngineInformation(String engineId, ApplicationDTO application) {
            this.engineId = engineId;
            this.application = application;
        }
    }
}

