/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.settings;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.phoenicis.repository.RepositoryConfiguration;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.Repository;
import org.phoenicis.settings.Setting;
import org.phoenicis.settings.Settings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.DefaultPropertiesPersister;

public class SettingsManager {
    @Value(value="${tools.linux-terminal:}")
    private String terminal;
    @Autowired
    private RepositoryConfiguration repositoryConfiguration;
    private String settingsFileName = "config.properties";

    public SettingsManager(String settingsFileName) {
        this.settingsFileName = settingsFileName;
    }

    public void save() {
        Settings settings = this.load();
        try (FileOutputStream outputStream = new FileOutputStream(new File(this.settingsFileName));){
            DefaultPropertiesPersister persister = new DefaultPropertiesPersister();
            persister.store(settings.getProperties(), (OutputStream)outputStream, "Phoenicis User Settings");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Settings load() {
        Settings settings = new Settings();
        settings.set(Setting.TERMINAL, this.terminal);
        return settings;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public void restoreDefaultRepositories() {
        this.repositoryConfiguration.restoreDefault();
    }

    public void saveRepositories(List<RepositoryLocation<? extends Repository>> repositoryLocations) {
        this.repositoryConfiguration.repositoryLocationLoader().saveRepositories(repositoryLocations);
    }

    public List<RepositoryLocation<? extends Repository>> loadRepositoryLocations() {
        return this.repositoryConfiguration.repositoryLocationLoader().loadRepositoryLocations();
    }
}

