/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.collections;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.phoenicis.javafx.collections.TransformationListBase;

public class MappedList<E, F>
extends TransformationListBase<E, F> {
    private final ObjectProperty<Function<? super F, ? extends E>> mapper;
    private final List<E> mappedValues;

    public MappedList(ObservableList<? extends F> source, ObjectProperty<Function<? super F, ? extends E>> mapper) {
        super(source);
        this.mapper = mapper;
        this.mappedValues = new ArrayList();
        Optional.ofNullable(this.getMapper()).ifPresent(mapperFunction -> source.stream().map(mapperFunction).forEach(this.mappedValues::add));
        mapper.addListener((observable, oldMapper, newMapper) -> {
            this.beginChange();
            if (oldMapper != null) {
                ArrayList<E> removed = new ArrayList<E>(this.mappedValues);
                this.mappedValues.clear();
                this.nextRemove(0, removed);
            }
            if (newMapper != null) {
                for (Object element : this.getSource()) {
                    this.mappedValues.add(newMapper.apply(element));
                }
                this.nextAdd(0, this.size());
            }
            this.endChange();
        });
        this.fireInitialisationChange();
    }

    public MappedList(ObservableList<? extends F> source, Function<? super F, ? extends E> mapper) {
        this(source, (ObjectProperty<Function<? extends F, E>>)new SimpleObjectProperty(mapper));
    }

    public MappedList(ObservableList<? extends F> source) {
        this(source, (ObjectProperty<Function<? extends F, E>>)new SimpleObjectProperty());
    }

    public int getSourceIndex(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }

    public int getViewIndex(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }

    public E get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.mappedValues.get(index);
    }

    public int size() {
        return Optional.ofNullable(this.getMapper()).map(mapper -> this.getSource().size()).orElse(0);
    }

    @Override
    protected void permute(ListChangeListener.Change<? extends F> change) {
        int from = change.getFrom();
        int to = change.getTo();
        if (to > from) {
            ArrayList<E> clone = new ArrayList<E>(this.mappedValues);
            int[] perm = IntStream.range(0, this.size()).toArray();
            for (int i = from; i < to; ++i) {
                perm[i] = change.getPermutation(i);
                this.mappedValues.set(i, clone.get(change.getPermutation(i)));
            }
            this.nextPermutation(from, to, perm);
        }
    }

    @Override
    protected void update(ListChangeListener.Change<? extends F> change) {
        int from = change.getFrom();
        int to = change.getTo();
        Function<F, E> mapper = this.getMapper();
        if (mapper != null) {
            for (int i = from; i < to; ++i) {
                this.mappedValues.set(i, mapper.apply(this.getSource().get(i)));
                this.nextUpdate(i);
            }
        }
    }

    @Override
    protected void addRemove(ListChangeListener.Change<? extends F> change) {
        int from = change.getFrom();
        Function<F, E> mapper = this.getMapper();
        if (mapper != null) {
            int index;
            for (index = from + change.getRemovedSize() - 1; index >= from; --index) {
                this.nextRemove(index, this.mappedValues.remove(index));
            }
            for (index = from; index < from + change.getAddedSize(); ++index) {
                this.mappedValues.add(index, mapper.apply(this.getSource().get(index)));
                this.nextAdd(index, index + 1);
            }
        }
    }

    public Function<? super F, ? extends E> getMapper() {
        return (Function)this.mapper.get();
    }

    public void setMapper(Function<? super F, ? extends E> mapper) {
        this.mapper.set(mapper);
    }

    public ObjectProperty<Function<? super F, ? extends E>> mapperProperty() {
        return this.mapper;
    }
}

