/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.collections.TransformationListBase;

public class ConcatenatedList<E>
extends TransformationListBase<E, ObservableList<? extends E>> {
    private final List<ListChangeListener<E>> innerListeners = new ArrayList<ListChangeListener<E>>();
    private final List<List<? extends E>> expandedValues;

    public ConcatenatedList(ObservableList<? extends ObservableList<? extends E>> source) {
        super(source);
        this.expandedValues = source.stream().map(ArrayList::new).collect(Collectors.toList());
        for (int innerListIndex = 0; innerListIndex < source.size(); ++innerListIndex) {
            ObservableList innerList = (ObservableList)this.getSource().get(innerListIndex);
            this.addUpdateListener(innerList, innerListIndex);
        }
        this.fireInitialisationChange();
    }

    @SafeVarargs
    public static <F> ConcatenatedList<F> createPrefixList(ObservableList<? extends F> list, F ... prefixes) {
        return new ConcatenatedList(FXCollections.observableArrayList(List.of(FXCollections.observableArrayList((Object[])prefixes), list)));
    }

    @SafeVarargs
    public static <F> ConcatenatedList<F> createSuffixList(ObservableList<? extends F> list, F ... suffixes) {
        return new ConcatenatedList(FXCollections.observableArrayList(List.of(list, FXCollections.observableArrayList((Object[])suffixes))));
    }

    @SafeVarargs
    public static <F> ConcatenatedList<F> create(ObservableList<? extends F> ... lists) {
        return new ConcatenatedList(FXCollections.observableArrayList((Object[])lists));
    }

    @SafeVarargs
    public static <F> ConcatenatedList<F> create(List<? extends F> ... lists) {
        return new ConcatenatedList(FXCollections.observableArrayList((Collection)Arrays.stream(lists).map(FXCollections::observableArrayList).collect(Collectors.toList())));
    }

    public static <F> ConcatenatedList<F> create(ObservableList<? extends List<? extends F>> list) {
        return new ConcatenatedList(new MappedList<ObservableList, List>(list, FXCollections::observableArrayList));
    }

    private int getFirstIndex(int sourceIndex) {
        int position = 0;
        for (int i = 0; i < sourceIndex; ++i) {
            List<E> innerList = this.expandedValues.get(i);
            position += innerList.size();
        }
        return position;
    }

    private int getLastIndexPlusOne(int sourceIndex) {
        int position = 0;
        for (int i = 0; i <= sourceIndex; ++i) {
            List<E> innerList = this.expandedValues.get(i);
            position += innerList.size();
        }
        return position;
    }

    public int getSourceIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int sum = 0;
        int sourceIndex = -1;
        for (List<E> innerList : this.expandedValues) {
            if (index < sum) break;
            sum += innerList.size();
            ++sourceIndex;
        }
        return sourceIndex;
    }

    public int getViewIndex(int index) {
        return this.getFirstIndex(index);
    }

    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        E result = null;
        int start = 0;
        for (List<E> innerList : this.expandedValues) {
            if (start + innerList.size() > index) {
                result = innerList.get(index - start);
                break;
            }
            start += innerList.size();
        }
        return result;
    }

    public int size() {
        return this.expandedValues.stream().mapToInt(List::size).sum();
    }

    @Override
    protected void permute(ListChangeListener.Change<? extends ObservableList<? extends E>> change) {
        int from = change.getFrom();
        int to = change.getTo();
        int expandedFrom = this.getFirstIndex(from);
        int expandedTo = this.getLastIndexPlusOne(to - 1);
        if (to > from) {
            List beforePermutation = this.expandedValues.stream().flatMap(Collection::stream).collect(Collectors.toList());
            ArrayList<List<List<? extends E>>> valuesClone = new ArrayList<List<List<? extends E>>>(this.expandedValues);
            for (int i = from; i < to; ++i) {
                valuesClone.set(i, this.expandedValues.get(change.getPermutation(i)));
            }
            this.expandedValues.clear();
            this.expandedValues.addAll(valuesClone);
            List afterPermutation = this.expandedValues.stream().flatMap(Collection::stream).collect(Collectors.toList());
            int[] perm = beforePermutation.stream().mapToInt(afterPermutation::indexOf).toArray();
            this.nextPermutation(expandedFrom, expandedTo, perm);
        }
    }

    @Override
    protected void update(ListChangeListener.Change<? extends ObservableList<? extends E>> change) {
        int from = change.getFrom();
        int to = change.getTo();
        for (int i = from; i < to; ++i) {
            int count;
            ObservableList oldValues = (ObservableList)change.getRemoved().get(i - from);
            this.removeUpdateListener(oldValues, i);
            ObservableList newValues = (ObservableList)change.getAddedSubList().get(i - from);
            this.expandedValues.set(i, new ArrayList(newValues));
            this.addUpdateListener(newValues, i);
            int firstOldIndex = this.getFirstIndex(i);
            if (oldValues.size() > newValues.size()) {
                for (count = 0; count < newValues.size(); ++count) {
                    this.nextUpdate(firstOldIndex + count);
                }
                this.nextRemove(firstOldIndex, oldValues.subList(newValues.size(), oldValues.size()));
            }
            if (oldValues.size() < newValues.size()) {
                for (count = 0; count < oldValues.size(); ++count) {
                    this.nextUpdate(firstOldIndex + count);
                }
                this.nextAdd(firstOldIndex + oldValues.size(), firstOldIndex + newValues.size());
            }
            if (oldValues.size() != newValues.size()) continue;
            for (count = 0; count < oldValues.size(); ++count) {
                this.nextUpdate(firstOldIndex + count);
            }
        }
    }

    @Override
    protected void addRemove(ListChangeListener.Change<? extends ObservableList<? extends E>> change) {
        int index;
        int from = change.getFrom();
        for (int removedIndex = change.getRemovedSize() - 1; removedIndex >= 0; --removedIndex) {
            index = from + removedIndex;
            ObservableList oldValues = (ObservableList)change.getRemoved().get(removedIndex);
            this.removeUpdateListener(oldValues, removedIndex);
            int firstOldIndex = this.getFirstIndex(index);
            this.nextRemove(firstOldIndex, this.expandedValues.remove(index));
        }
        for (int addedIndex = 0; addedIndex < change.getAddedSize(); ++addedIndex) {
            index = from + addedIndex;
            ObservableList newValues = (ObservableList)change.getAddedSubList().get(addedIndex);
            this.expandedValues.add(index, new ArrayList(newValues));
            this.addUpdateListener(newValues, addedIndex);
            int lastOldIndex = this.getLastIndexPlusOne(index - 1);
            this.nextAdd(lastOldIndex, lastOldIndex + newValues.size());
        }
    }

    private void addUpdateListener(ObservableList<? extends E> innerList, int innerListIndex) {
        ListChangeListener innerListener = change -> {
            ObservableList activatorList = change.getList();
            this.beginChange();
            while (change.next()) {
                this.expandedValues.set(innerListIndex, new ArrayList(activatorList));
                int expandedFrom = this.getFirstIndex(innerListIndex);
                if (change.wasPermutated()) {
                    this.nextPermutation(expandedFrom + change.getFrom(), expandedFrom + change.getTo(), IntStream.range(change.getFrom(), change.getTo()).map(arg_0 -> ((ListChangeListener.Change)change).getPermutation(arg_0)).toArray());
                    continue;
                }
                if (change.wasUpdated()) {
                    IntStream.range(expandedFrom + change.getFrom(), expandedFrom + change.getTo()).forEach(arg_0 -> ((ConcatenatedList)this).nextUpdate(arg_0));
                    continue;
                }
                this.nextRemove(expandedFrom + change.getFrom(), change.getRemoved());
                this.nextAdd(expandedFrom + change.getFrom(), expandedFrom + change.getFrom() + change.getAddedSize());
            }
            this.endChange();
        };
        this.innerListeners.add(innerListIndex, innerListener);
        innerList.addListener(innerListener);
    }

    private void removeUpdateListener(ObservableList<? extends E> innerList, int innerListIndex) {
        ListChangeListener<E> innerListener = this.innerListeners.remove(innerListIndex);
        innerList.removeListener(innerListener);
    }
}

