/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.entities;

import org.phoenicis.entities.ProgressState;

public class ProgressEntity {
    private final ProgressState state;
    private final double percent;
    private final String progressText;

    private ProgressEntity(Builder builder) {
        this.state = builder.state;
        this.percent = builder.percent;
        this.progressText = builder.progressText;
    }

    public ProgressState getState() {
        return this.state;
    }

    public double getPercent() {
        return this.percent;
    }

    public String getProgressText() {
        return this.progressText;
    }

    public String toString() {
        return this.state.name();
    }

    public static class Builder {
        private ProgressState state;
        private double percent;
        private String progressText;

        public Builder() {
        }

        public Builder(ProgressEntity other) {
            this.state = other.state;
            this.percent = other.percent;
            this.progressText = other.progressText;
        }

        public Builder withState(ProgressState state) {
            this.state = state;
            return this;
        }

        public Builder withPercent(double percent) {
            this.percent = percent;
            return this;
        }

        public Builder withProgressText(String progressText) {
            this.progressText = progressText;
            return this;
        }

        public ProgressEntity build() {
            return new ProgressEntity(this);
        }
    }
}

