/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.entities;

public enum OperatingSystem {
    MACOSX("Mac OS X", "Mac", "darwin"),
    LINUX("Linux", "Linux", "linux"),
    FREEBSD("FreeBSD", "FreeBSD", "freebsd");

    private final String fullName;
    private final String legacyName;
    private final String winePackage;

    private OperatingSystem(String fullName, String legacyName, String winePackage) {
        this.fullName = fullName;
        this.legacyName = legacyName;
        this.winePackage = winePackage;
    }

    public static OperatingSystem fromString(String fullName) {
        for (OperatingSystem system : OperatingSystem.values()) {
            if (!system.getFullName().equals(fullName)) continue;
            return system;
        }
        throw new IllegalArgumentException(String.format("Incompatible operation system \"%s\"", fullName));
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getLegacyName() {
        return this.legacyName;
    }

    public String getWinePackage() {
        return this.winePackage;
    }

    public String toString() {
        return this.fullName;
    }
}

