/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.scriptui;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.text.Text;
import org.phoenicis.entities.ProgressEntity;
import org.phoenicis.javafx.views.scriptui.SetupUiJavaFXImplementation;
import org.phoenicis.javafx.views.scriptui.StepRepresentationMessage;
import org.phoenicis.scripts.ui.Message;
import org.phoenicis.scripts.ui.ProgressControl;

public class StepRepresentationProgressBar
extends StepRepresentationMessage
implements ProgressControl {
    private final ProgressBar progressBar = new ProgressBar();
    private final Text progressText = new Text("");

    public StepRepresentationProgressBar(SetupUiJavaFXImplementation parent, Message<?> messageWaitingForResponse, String textToShow) {
        super(parent, messageWaitingForResponse, textToShow);
        this.progressBar.setProgress(0.0);
        this.progressText.setId("stepText");
    }

    @Override
    protected void drawStepContent() {
        super.drawStepContent();
        this.progressBar.setPrefHeight(30.0);
        this.progressBar.prefWidthProperty().bind((ObservableValue)this.getContentPane().widthProperty());
        this.addToContentPane((Node)this.progressBar);
        this.addToContentPane((Node)this.progressText);
    }

    @Override
    protected void setStepEvents() {
        this.setNextButtonEnabled(false);
    }

    public void setProgressPercentage(double value) {
        Platform.runLater(() -> this.progressBar.setProgress(value / 100.0));
    }

    public void setText(String text) {
        Platform.runLater(() -> this.progressText.setText(text));
    }

    public void accept(ProgressEntity progressStateEntity) {
        this.setProgressPercentage(progressStateEntity.getPercent());
        this.setText(progressStateEntity.getProgressText());
    }
}

