/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.scriptui;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import org.apache.commons.lang.StringUtils;
import org.phoenicis.javafx.views.scriptui.SetupUiJavaFXImplementation;
import org.phoenicis.javafx.views.scriptui.StepRepresentationMessage;
import org.phoenicis.scripts.ui.MenuItem;
import org.phoenicis.scripts.ui.Message;

public class StepRepresentationMenu
extends StepRepresentationMessage {
    private final String defaultValue;
    private final List<String> menuItems;
    private final ListView<String> listViewWidget;
    private final Message<MenuItem> messageWaitingForResponse;

    public StepRepresentationMenu(SetupUiJavaFXImplementation parent, Message<MenuItem> messageWaitingForResponse, String textToShow, List<String> menuItems, String defaultValue) {
        super(parent, messageWaitingForResponse, textToShow);
        this.messageWaitingForResponse = messageWaitingForResponse;
        this.menuItems = menuItems;
        this.listViewWidget = new ListView();
        this.defaultValue = defaultValue;
    }

    @Override
    protected void drawStepContent() {
        super.drawStepContent();
        this.listViewWidget.setItems(FXCollections.observableArrayList(this.menuItems));
        if (this.defaultValue != null) {
            int idx = this.menuItems.indexOf(this.defaultValue);
            if (idx != -1) {
                this.listViewWidget.getSelectionModel().select(idx);
                this.listViewWidget.getFocusModel().focus(idx);
                this.listViewWidget.scrollTo(idx);
            }
            if (StringUtils.isBlank((String)this.defaultValue)) {
                this.setNextButtonEnabled(false);
                this.listViewWidget.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                    if (StringUtils.isBlank((String)newValue)) {
                        this.setNextButtonEnabled(false);
                    } else {
                        this.setNextButtonEnabled(true);
                    }
                });
            }
        }
        this.addToContentPane((Node)this.listViewWidget);
    }

    @Override
    protected void setStepEvents() {
        this.setNextButtonAction((EventHandler<MouseEvent>)((EventHandler)event -> {
            MenuItem menuItem = new MenuItem((String)this.listViewWidget.getSelectionModel().getSelectedItem(), this.listViewWidget.getSelectionModel().getSelectedIndex());
            this.messageWaitingForResponse.send((Object)menuItem);
        }));
    }
}

