/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.scriptui;

import java.util.concurrent.Semaphore;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.web.WebView;
import org.phoenicis.javafx.views.scriptui.SetupUiJavaFXImplementation;
import org.phoenicis.javafx.views.scriptui.StepRepresentationMessage;
import org.phoenicis.scripts.ui.BrowserControl;
import org.phoenicis.scripts.ui.Message;

public class StepRepresentationBrowser
extends StepRepresentationMessage
implements BrowserControl {
    private final WebView webView = new WebView();
    private final Message<?> messageWaitingForResponse;

    public StepRepresentationBrowser(SetupUiJavaFXImplementation parent, Message<?> messageWaitingForResponse, String textToShow) {
        super(parent, messageWaitingForResponse, textToShow);
        this.messageWaitingForResponse = messageWaitingForResponse;
    }

    @Override
    protected void drawStepContent() {
        super.drawStepContent();
        this.webView.prefWidthProperty().bind((ObservableValue)this.getContentPane().widthProperty());
        this.webView.getEngine().setUserAgent("use required / intended UA string");
        this.addToContentPane((Node)this.webView);
    }

    @Override
    protected void setStepEvents() {
        this.setNextButtonEnabled(false);
    }

    public void goToUrl(String url) {
        Platform.runLater(() -> this.webView.getEngine().load(url));
    }

    public void waitForUrl(String urlMatch) {
        Semaphore lock = new Semaphore(0);
        Platform.runLater(() -> this.webView.getEngine().getLoadWorker().stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED && this.urlMatches(this.getCurrentUrl(), urlMatch)) {
                lock.release();
            }
        }));
        try {
            lock.acquire();
        }
        catch (InterruptedException e) {
            this.messageWaitingForResponse.sendCancelSignal();
        }
    }

    private boolean urlMatches(String urlToTest, String pattern) {
        if (urlToTest.equals(pattern)) {
            return true;
        }
        return pattern.endsWith("*") && urlToTest.startsWith(pattern.replace("*", ""));
    }

    public void waitForBeingLoaded() {
        Semaphore lock = new Semaphore(0);
        Platform.runLater(() -> this.webView.getEngine().getLoadWorker().stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                lock.release();
            }
        }));
        try {
            lock.acquire();
        }
        catch (InterruptedException e) {
            this.messageWaitingForResponse.sendCancelSignal();
        }
    }

    public String getCurrentUrl() {
        if (this.webView.getEngine().getDocument() == null) {
            return "";
        }
        return this.webView.getEngine().getDocument().getDocumentURI();
    }
}

