/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.scriptui;

import java.io.File;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.views.scriptui.AbstractStepRepresentationWithHeader;
import org.phoenicis.javafx.views.scriptui.SetupUiJavaFXImplementation;
import org.phoenicis.scripts.ui.Message;

public class StepRepresentationBrowse
extends AbstractStepRepresentationWithHeader {
    private final File browseDirectory;
    private final Message<String> message;
    private final String textToShow;
    private List<String> extensions;
    private File selectedFile;

    public StepRepresentationBrowse(SetupUiJavaFXImplementation parent, Message<String> message, String textToShow, File browseDirectory, List<String> extensions) {
        super(parent, message);
        this.browseDirectory = browseDirectory;
        this.extensions = extensions;
        this.message = message;
        this.textToShow = textToShow;
    }

    @Override
    public void drawStepContent() {
        this.addToContentPane(this.dragPane());
        this.setNextButtonEnabled(false);
    }

    private Node dragPane() {
        Text textLabel = new Text(this.textToShow);
        Text dragLabel = new Text((String)Localisation.tr((Object)"Click or drag-and-drop file here"));
        textLabel.getStyleClass().add((Object)"boldLabel");
        dragLabel.getStyleClass().addAll((Object[])new String[]{"normalLabel"});
        VBox dragTarget = new VBox();
        dragTarget.getChildren().addAll((Object[])new Node[]{textLabel, dragLabel});
        dragTarget.setOnDragOver(event -> {
            if (event.getGestureSource() != dragTarget && event.getDragboard().hasFiles()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            event.consume();
        });
        dragTarget.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasFiles()) {
                this.selectFile((File)db.getFiles().get(0));
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
        dragTarget.setPrefSize(660.0, 308.0);
        dragTarget.getStyleClass().addAll((Object[])new String[]{"dragAndDropBox"});
        dragTarget.setOnMouseClicked(event -> {
            FileChooser fileChooser = new FileChooser();
            if (this.extensions != null) {
                fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter((String)Localisation.tr((Object)"Allowed file types"), this.extensions));
            }
            fileChooser.setInitialDirectory(this.browseDirectory);
            File dialogResult = fileChooser.showOpenDialog(null);
            if (dialogResult != null) {
                this.selectFile(dialogResult);
            }
        });
        return dragTarget;
    }

    private void selectFile(File selectedFile) {
        if (selectedFile != null) {
            this.message.send((Object)selectedFile.getAbsolutePath());
        }
    }

    @Override
    protected void setStepEvents() {
        this.setNextButtonAction((EventHandler<MouseEvent>)((EventHandler)event -> this.message.send((Object)this.selectedFile.toString())));
    }
}

