/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.scriptui;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.layout.BorderPane;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.javafx.views.scriptui.StepRepresentationBrowse;
import org.phoenicis.javafx.views.scriptui.StepRepresentationBrowser;
import org.phoenicis.javafx.views.scriptui.StepRepresentationHtmlPresentation;
import org.phoenicis.javafx.views.scriptui.StepRepresentationLicence;
import org.phoenicis.javafx.views.scriptui.StepRepresentationMenu;
import org.phoenicis.javafx.views.scriptui.StepRepresentationMessage;
import org.phoenicis.javafx.views.scriptui.StepRepresentationPresentation;
import org.phoenicis.javafx.views.scriptui.StepRepresentationProgressBar;
import org.phoenicis.javafx.views.scriptui.StepRepresentationSpin;
import org.phoenicis.javafx.views.scriptui.StepRepresentationTextBox;
import org.phoenicis.scripts.ui.BrowserControl;
import org.phoenicis.scripts.ui.MenuItem;
import org.phoenicis.scripts.ui.Message;
import org.phoenicis.scripts.ui.ProgressControl;
import org.phoenicis.scripts.ui.SetupUi;
import org.phoenicis.tools.system.OperatingSystemFetcher;

public class SetupUiJavaFXImplementation
extends Tab
implements SetupUi {
    private final ThemeManager themeManager;
    private final BorderPane root;
    private final String wizardTitle;
    private URL topImage;
    private String leftImageText;
    private Runnable onShouldClose = () -> {};
    private final OperatingSystemFetcher operatingSystemFetcher;

    public SetupUiJavaFXImplementation(String title, OperatingSystemFetcher operatingSystemFetcher, ThemeManager themeManager) {
        this.themeManager = themeManager;
        this.operatingSystemFetcher = operatingSystemFetcher;
        this.root = new BorderPane();
        this.wizardTitle = title;
        this.setText((String)Localisation.tr((Object)title));
        this.setContent((Node)this.root);
        this.loadImages();
    }

    public String getWizardTitle() {
        return this.wizardTitle;
    }

    public BorderPane getRoot() {
        return this.root;
    }

    public void clearAll() {
        this.root.getChildren().clear();
    }

    private void loadImages() {
        this.topImage = ((Object)((Object)this)).getClass().getResource("defaultTopImage.png");
        switch (this.operatingSystemFetcher.fetchCurrentOperationSystem()) {
            case MACOSX: {
                this.leftImageText = "playonmac";
                break;
            }
            default: {
                this.leftImageText = "phoenicis";
            }
        }
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public void addNode(Node widgetToAdd) {
        this.root.getChildren().add((Object)widgetToAdd);
    }

    public void showSimpleMessageStep(Message message, String textToShow) {
        StepRepresentationMessage stepMessage = new StepRepresentationMessage(this, message, textToShow);
        stepMessage.installStep();
    }

    public void showYesNoQuestionStep() {
    }

    public void showTextBoxStep(Message<String> message, String textToShow, String defaultValue) {
        StepRepresentationTextBox stepTextBox = new StepRepresentationTextBox(this, message, textToShow, defaultValue);
        stepTextBox.installStep();
    }

    public void showMenuStep(Message<MenuItem> message, String textToShow, List<String> menuItems, String defaultValue) {
        StepRepresentationMenu stepMenu = new StepRepresentationMenu(this, message, textToShow, menuItems, defaultValue);
        stepMenu.installStep();
    }

    public void showSpinnerStep(Message<Void> message, String textToShow) {
        StepRepresentationSpin stepSpin = new StepRepresentationSpin(this, message, textToShow);
        stepSpin.installStep();
        message.send(null);
    }

    public void showProgressBar(Message<ProgressControl> message, String textToShow) {
        StepRepresentationProgressBar stepProgressBar = new StepRepresentationProgressBar(this, message, textToShow);
        stepProgressBar.installStep();
        message.send((Object)stepProgressBar);
    }

    public void showBrowser(Message<BrowserControl> message, String textToShow) {
        StepRepresentationBrowser stepBrowser = new StepRepresentationBrowser(this, message, textToShow);
        stepBrowser.installStep();
        message.send((Object)stepBrowser);
    }

    public void showHtmlPresentationStep(Message<Void> message, String htmlToShow) {
        StepRepresentationHtmlPresentation stepRepresentationHtmlPresentation = new StepRepresentationHtmlPresentation(this, message, htmlToShow);
        stepRepresentationHtmlPresentation.installStep();
    }

    public void showPresentationStep(Message<Void> message, String textToShow) {
        StepRepresentationPresentation stepRepresentationPresentation = new StepRepresentationPresentation(this, message, textToShow);
        stepRepresentationPresentation.installStep();
    }

    public void showLicenceStep(Message<Void> message, String textToShow, String licenceText) {
        StepRepresentationLicence stepRepresentationLicence = new StepRepresentationLicence(this, message, textToShow, licenceText);
        stepRepresentationLicence.installStep();
    }

    public void showBrowseStep(Message<String> message, String textToShow, File browseDirectory, List<String> extensions) {
        StepRepresentationBrowse stepRepresentationBrowse = new StepRepresentationBrowse(this, message, textToShow, browseDirectory, extensions);
        stepRepresentationBrowse.installStep();
    }

    public void close() {
        this.onShouldClose.run();
    }

    public void setTopImage(File topImage) throws MalformedURLException {
        this.topImage = new URL(topImage.getAbsolutePath());
    }

    public void setTopImage(URL topImage) throws IOException {
        this.topImage = topImage;
    }

    public void setLeftImageText(String leftImageText) {
        this.leftImageText = leftImageText;
    }

    public String getLeftImageText() {
        return this.leftImageText;
    }

    public URL getTopImage() {
        return this.topImage;
    }

    public void setOnShouldClose(Runnable onShouldClose) {
        this.onShouldClose = onShouldClose;
    }
}

