/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.scriptui;

import java.net.URI;
import java.util.Date;
import java.util.Optional;
import org.phoenicis.configuration.security.Safe;
import org.phoenicis.javafx.components.installation.control.InstallationsFeaturePanel;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationDTO;
import org.phoenicis.javafx.views.scriptui.SetupUiJavaFXImplementation;
import org.phoenicis.scripts.ui.InstallationType;
import org.phoenicis.scripts.ui.SetupUi;
import org.phoenicis.scripts.ui.SetupUiFactory;
import org.phoenicis.tools.system.OperatingSystemFetcher;

@Safe
public class SetupUiFactoryJavaFX
implements SetupUiFactory {
    private OperatingSystemFetcher operatingSystemFetcher;
    private ThemeManager themeManager;
    private InstallationsFeaturePanel installationsView;

    public SetupUiFactoryJavaFX(OperatingSystemFetcher operatingSystemFetcher, ThemeManager themeManager, InstallationsFeaturePanel installationsView) {
        this.operatingSystemFetcher = operatingSystemFetcher;
        this.themeManager = themeManager;
        this.installationsView = installationsView;
    }

    public SetupUi createSetupWindow(String title, Optional<URI> miniature, InstallationType installationType) {
        SetupUiJavaFXImplementation setupWindow = new SetupUiJavaFXImplementation(title, this.operatingSystemFetcher, this.themeManager);
        InstallationDTO installationDTO = new InstallationDTO.Builder().withCategory(installationType).withId(title + "_" + new Date().getTime()).withName(title).withMiniature(miniature.orElse(null)).withNode(setupWindow.getContent()).build();
        this.installationsView.addInstallation(installationDTO);
        setupWindow.setOnShouldClose(() -> this.installationsView.removeInstallation(installationDTO));
        return setupWindow;
    }
}

