/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.scriptui;

import java.net.URL;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.views.scriptui.SetupUiJavaFXImplementation;
import org.phoenicis.scripts.ui.Message;

abstract class AbstractStepRepresentation {
    private final Message<?> messageWaitingForResponse;
    private final SetupUiJavaFXImplementation parent;
    private Button nextButton;

    AbstractStepRepresentation(SetupUiJavaFXImplementation parent, Message<?> messageWaitingForResponse) {
        this.parent = parent;
        this.messageWaitingForResponse = messageWaitingForResponse;
    }

    protected SetupUiJavaFXImplementation getParent() {
        return this.parent;
    }

    protected Pane getParentRoot() {
        return this.parent.getRoot();
    }

    protected URL getParentTopImage() {
        return this.parent.getTopImage();
    }

    public String getParentWizardTitle() {
        return this.parent.getWizardTitle();
    }

    public void clearAllOnParent() {
        this.parent.clearAll();
    }

    protected Message<?> getMessageAwaitingForResponse() {
        return this.messageWaitingForResponse;
    }

    protected void drawLeftImage() {
        AnchorPane pane = new AnchorPane();
        pane.setPrefWidth(187.0);
        Stop[] stops = new Stop[]{new Stop(0.0, Color.web((String)"#3c79b2")), new Stop(1.0, Color.web((String)"#2d5d8b"))};
        RadialGradient gradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 1.0, true, CycleMethod.NO_CYCLE, stops);
        Background background = new Background(new BackgroundFill[]{new BackgroundFill((Paint)gradient, null, null)});
        pane.setBackground(background);
        Text text = new Text(this.parent.getLeftImageText());
        text.setFill((Paint)Color.WHITE);
        text.setFont(Font.font((String)"Maven Pro", (double)50.0));
        text.setRotate(-90.0);
        pane.setPadding(new Insets(-50.0));
        pane.getChildren().add((Object)text);
        AnchorPane.setBottomAnchor((Node)text, (Double)160.0);
        AnchorPane.setRightAnchor((Node)text, (Double)-40.0);
        this.getParent().getRoot().setLeft((Node)pane);
    }

    protected void drawFooter() {
        HBox footer = new HBox();
        footer.setAlignment(Pos.CENTER_RIGHT);
        footer.setPadding(new Insets(8.0));
        footer.setSpacing(10.0);
        footer.setPrefHeight(45.0);
        footer.setId("footer");
        this.getParent().getRoot().setBottom((Node)footer);
        Button cancelButton = new Button((String)Localisation.tr((Object)"Cancel"));
        this.nextButton = new Button((String)Localisation.tr((Object)"Next"));
        footer.getChildren().addAll((Object[])new Node[]{cancelButton, this.nextButton});
        cancelButton.setOnMouseClicked(event -> {
            cancelButton.setDisable(true);
            this.messageWaitingForResponse.sendCancelSignal();
        });
    }

    protected void setNextButtonAction(EventHandler<MouseEvent> nextButtonAction) {
        this.nextButton.setOnMouseClicked(event -> {
            this.nextButton.setDisable(true);
            nextButtonAction.handle(event);
        });
        this.getParent().setOnCloseRequest(event -> {
            if (this.messageWaitingForResponse != null) {
                this.messageWaitingForResponse.sendCancelSignal();
            }
            event.consume();
        });
    }

    protected void setNextButtonEnabled(Boolean nextEnabled) {
        this.nextButton.setDisable(nextEnabled == false);
    }

    protected abstract void drawStepContent();

    protected abstract void setStepEvents();

    public void installStep() {
        this.parent.clearAll();
        this.drawLeftImage();
        this.drawFooter();
        this.setStepEvents();
        this.drawStepContent();
    }
}

