/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.ui;

import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.javafx.views.mainwindow.ui.FailurePanel;

public class MainWindowView<S extends Node>
extends Tab {
    protected final ThemeManager themeManager;
    protected final BorderPane content;
    protected S sidebar;
    private HBox waitPanel;
    private FailurePanel failurePanel;

    public MainWindowView(String text, ThemeManager themeManager) {
        super(text);
        this.themeManager = themeManager;
        this.content = new BorderPane();
        this.content.getStyleClass().add((Object)"mainWindowScene");
        this.populateFailurePanel();
        this.waitPanel = this.createWaitPanel();
        this.content.setCenter((Node)this.waitPanel);
        this.setContent((Node)this.content);
    }

    private HBox createWaitPanel() {
        ProgressIndicator progressIndicator = new ProgressIndicator();
        progressIndicator.getStyleClass().add((Object)"waiting-indicator");
        HBox waitPanel = new HBox(new Node[]{progressIndicator});
        waitPanel.getStyleClass().add((Object)"rightPane");
        return waitPanel;
    }

    private void populateFailurePanel() {
        this.failurePanel = new FailurePanel();
    }

    protected void setSidebar(S sidebar) {
        this.sidebar = sidebar;
        this.content.setLeft(this.sidebar);
    }

    public void setCenter(Node nodeToShow) {
        this.closeDetailsView();
        this.content.setCenter(nodeToShow);
    }

    public void showDetailsView(Node nodeToShow) {
        this.content.setRight(nodeToShow);
    }

    public void closeDetailsView() {
        this.content.setRight(null);
    }

    public void showWait() {
        this.closeDetailsView();
        this.setCenter((Node)this.waitPanel);
    }

    public void showFailure(String notification, Optional<Exception> reason) {
        this.closeDetailsView();
        this.failurePanel.setFailure(notification, reason);
        this.setCenter((Node)this.failurePanel);
    }

    public FailurePanel getFailurePanel() {
        return this.failurePanel;
    }
}

