/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.ui;

import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.JavaFXApplication;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.application.control.ApplicationsFeaturePanel;
import org.phoenicis.javafx.components.common.control.TabIndicator;
import org.phoenicis.javafx.components.container.control.ContainersFeaturePanel;
import org.phoenicis.javafx.components.installation.control.InstallationsFeaturePanel;
import org.phoenicis.javafx.components.library.control.LibraryFeaturePanel;
import org.phoenicis.javafx.dialogs.ErrorDialog;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.javafx.utils.StringBindings;
import org.phoenicis.javafx.views.common.PhoenicisScene;
import org.phoenicis.javafx.views.mainwindow.engines.EnginesView;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationCategoryDTO;
import org.phoenicis.javafx.views.mainwindow.settings.SettingsView;

public class MainWindow
extends Stage {
    private TabPane tabPane = new TabPane();
    private Tab libraryTab;
    private Tab applicationsTab;
    private Tab containersTab;
    private Tab enginesTab;
    private Tab installationsTab;
    private Tab settingsTab;
    private JavaFxSettingsManager javaFxSettingsManager;

    public MainWindow(String applicationName, LibraryFeaturePanel library, ApplicationsFeaturePanel apps, EnginesView engines, ContainersFeaturePanel containers, InstallationsFeaturePanel installations, SettingsView settings, ThemeManager themeManager, JavaFxSettingsManager javaFxSettingsManager) {
        this.tabPane.setId("menuPane");
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.javaFxSettingsManager = javaFxSettingsManager;
        if (this.javaFxSettingsManager.isAdvancedMode()) {
            this.libraryTab = this.createLibraryTab(library);
            this.applicationsTab = this.createApplicationsTab(apps);
            this.containersTab = this.createContainersTab(containers);
            this.enginesTab = engines;
            this.installationsTab = this.createInstallationsTab(installations);
            this.settingsTab = settings;
            this.tabPane.getTabs().addAll((Object[])new Tab[]{this.libraryTab, this.applicationsTab, this.containersTab, this.enginesTab, this.installationsTab, this.settingsTab});
        } else {
            this.libraryTab = this.createLibraryTab(library);
            this.applicationsTab = this.createApplicationsTab(apps);
            this.installationsTab = this.createInstallationsTab(installations);
            this.settingsTab = settings;
            this.tabPane.getTabs().addAll((Object[])new Tab[]{this.libraryTab, this.applicationsTab, this.installationsTab, this.settingsTab});
        }
        PhoenicisScene scene = new PhoenicisScene((Parent)this.tabPane, themeManager, this.javaFxSettingsManager);
        this.getIcons().add((Object)new Image(JavaFXApplication.class.getResourceAsStream("/org/phoenicis/javafx/views/common/phoenicis.png")));
        this.setMinHeight(200.0);
        this.setMinWidth(200.0);
        this.setResizable(true);
        this.setHeight(this.javaFxSettingsManager.getWindowHeight());
        this.setWidth(this.javaFxSettingsManager.getWindowWidth());
        this.setMaximized(this.javaFxSettingsManager.isWindowMaximized());
        this.setScene(scene);
        this.setTitle(applicationName);
        this.show();
    }

    private Tab createLibraryTab(LibraryFeaturePanel library) {
        Tab libraryTab = new Tab((String)Localisation.tr((Object)"Library"), (Node)library);
        libraryTab.setClosable(false);
        return libraryTab;
    }

    private Tab createApplicationsTab(ApplicationsFeaturePanel apps) {
        Tab applicationsTab = new Tab((String)Localisation.tr((Object)"Apps"), (Node)apps);
        applicationsTab.setClosable(false);
        return applicationsTab;
    }

    private Tab createContainersTab(ContainersFeaturePanel containers) {
        Tab containersTab = new Tab((String)Localisation.tr((Object)"Containers"), (Node)containers);
        containersTab.setClosable(false);
        containersTab.setOnSelectionChanged(event -> containers.getContainersManager().fetchContainers(containerCategories -> Platform.runLater(() -> {
            containers.getCategories().setAll((Collection)containerCategories);
            containers.setInitialized(true);
        }), e -> Platform.runLater(() -> {
            ErrorDialog errorDialog = ErrorDialog.builder().withMessage((String)Localisation.tr((Object)"Loading containers failed.")).withException((Exception)e).withOwner(containers.getScene().getWindow()).build();
            errorDialog.showAndWait();
        })));
        return containersTab;
    }

    private Tab createInstallationsTab(InstallationsFeaturePanel installationsFeaturePanel) {
        Tab installationsTab = new Tab((String)Localisation.tr((Object)"Installations"), (Node)installationsFeaturePanel);
        installationsTab.setClosable(false);
        ConcatenatedList installations = ConcatenatedList.create((ObservableList)new MappedList(installationsFeaturePanel.getInstallationCategories(), InstallationCategoryDTO::getInstallations));
        IntegerBinding openInstallations = Bindings.createIntegerBinding(() -> ((ConcatenatedList)installations).size(), (Observable[])new Observable[]{installations});
        TabIndicator indicator = new TabIndicator();
        indicator.textProperty().bind((ObservableValue)StringBindings.map(openInstallations, numberOfInstallations -> {
            if (numberOfInstallations.intValue() < 10) {
                return String.valueOf(numberOfInstallations);
            }
            return "+";
        }));
        installationsTab.graphicProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.notEqual((ObservableNumberValue)openInstallations, (int)0)).then((Object)indicator).otherwise((ObservableObjectValue)new SimpleObjectProperty()));
        return installationsTab;
    }

    public void showInstallations() {
        if (this.javaFxSettingsManager.isAdvancedMode()) {
            this.tabPane.getSelectionModel().select(4);
        } else {
            this.tabPane.getSelectionModel().select(2);
        }
    }

    public Tab getLibraryTab() {
        return this.libraryTab;
    }

    public Tab getApplicationsTab() {
        return this.applicationsTab;
    }

    public Tab getContainersTab() {
        return this.containersTab;
    }

    public Tab getEnginesTab() {
        return this.enginesTab;
    }

    public Tab getInstallationsTab() {
        return this.installationsTab;
    }

    public Tab getSettingsTab() {
        return this.settingsTab;
    }
}

