/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.settings.addrepository;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.views.mainwindow.settings.addrepository.RepositoryDetailsPanel;
import org.phoenicis.repository.location.GitRepositoryLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepositoryDetailsPanel
extends RepositoryDetailsPanel<GitRepositoryLocation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitRepositoryDetailsPanel.class);
    private TextField urlField;
    private TextField branchField;

    public GitRepositoryDetailsPanel() {
        this.populate();
    }

    private void populate() {
        this.urlField = new TextField();
        this.branchField = new TextField("master");
        Label urlLabel = new Label((String)Localisation.tr((Object)"Git-URL:"));
        urlLabel.setLabelFor((Node)this.urlField);
        Label branchLabel = new Label((String)Localisation.tr((Object)"Git-Branch:"));
        branchLabel.setLabelFor((Node)this.branchField);
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"grid");
        grid.add((Node)urlLabel, 0, 0);
        grid.add((Node)this.urlField, 1, 0);
        grid.add((Node)branchLabel, 0, 1);
        grid.add((Node)this.branchField, 1, 1);
        this.setCenter((Node)grid);
    }

    @Override
    public String getHeader() {
        return (String)Localisation.tr((Object)"Choose the location of the git repository");
    }

    @Override
    public GitRepositoryLocation createRepositoryLocation() {
        try {
            return new GitRepositoryLocation.Builder().withGitRepositoryUri(new URL(this.urlField.getText()).toURI()).withBranch(this.branchField.getText()).build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.error(String.format("The given url '%s' is no valid URI or URL", this.urlField.getText()), (Throwable)e);
            return null;
        }
    }
}

