/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.settings.addrepository;

import java.util.Arrays;
import java.util.function.Consumer;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.views.mainwindow.settings.addrepository.RepositoryType;

public class ChooseRepositoryTypePanel
extends BorderPane {
    private ObservableList<RepositoryType> repositoryChoices = FXCollections.observableArrayList((Object[])RepositoryType.values());
    private ComboBox<RepositoryType> choiceBox;
    private Consumer<RepositoryType> onRepositoryTypeSelection;

    public ChooseRepositoryTypePanel() {
        this.populate();
    }

    private void populate() {
        this.choiceBox = new ComboBox(this.repositoryChoices);
        this.choiceBox.setPromptText((String)Localisation.tr((Object)"Please select the repository type you want to add"));
        this.choiceBox.setConverter((StringConverter)new StringConverter<RepositoryType>(){

            public String toString(RepositoryType repositoryType) {
                return repositoryType.getLabel();
            }

            public RepositoryType fromString(String string) {
                return Arrays.stream(RepositoryType.values()).filter(type -> type.getLabel().equals(string)).findAny().orElse(null);
            }
        });
        this.choiceBox.setOnAction(event -> this.onRepositoryTypeSelection.accept((RepositoryType)((Object)((Object)this.choiceBox.getSelectionModel().getSelectedItem()))));
        Label choiceBoxLabel = new Label((String)Localisation.tr((Object)"Repository type:"));
        choiceBoxLabel.setLabelFor(this.choiceBox);
        HBox content = new HBox(new Node[]{choiceBoxLabel, this.choiceBox});
        content.setId("repositoryTypeSelection");
        HBox.setHgrow(this.choiceBox, (Priority)Priority.ALWAYS);
        this.setCenter((Node)content);
    }

    public String getHeader() {
        return (String)Localisation.tr((Object)"Choose repository type...");
    }

    public void setOnRepositoryTypeSelection(Consumer<RepositoryType> onRepositoryTypeSelection) {
        this.onRepositoryTypeSelection = onRepositoryTypeSelection;
    }
}

