/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.settings;

import java.util.Collection;
import java.util.List;
import javafx.animation.PauseTransition;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.util.Duration;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.components.setting.control.AboutPanel;
import org.phoenicis.javafx.components.setting.control.FileAssociationsPanel;
import org.phoenicis.javafx.components.setting.control.NetworkPanel;
import org.phoenicis.javafx.components.setting.control.RepositoriesPanel;
import org.phoenicis.javafx.components.setting.control.SettingsSidebar;
import org.phoenicis.javafx.components.setting.control.UserInterfacePanel;
import org.phoenicis.javafx.components.setting.utils.ApplicationBuildInformation;
import org.phoenicis.javafx.components.setting.utils.SettingsSidebarItem;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.themes.Theme;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.javafx.themes.Themes;
import org.phoenicis.javafx.views.mainwindow.ui.MainWindowView;
import org.phoenicis.repository.RepositoryLocationLoader;
import org.phoenicis.repository.RepositoryManager;
import org.phoenicis.repository.location.RepositoryLocation;
import org.phoenicis.repository.types.Repository;
import org.phoenicis.settings.SettingsManager;
import org.phoenicis.tools.system.opener.Opener;

public class SettingsView
extends MainWindowView<SettingsSidebar> {
    private final PauseTransition pause = new PauseTransition(Duration.seconds((double)0.5));
    private final String applicationName;
    private final String applicationVersion;
    private final String applicationGitRevision;
    private final String applicationBuildTimestamp;
    private final Opener opener;
    private final RepositoryLocationLoader repositoryLocationLoader;
    private SettingsManager settingsManager;
    private JavaFxSettingsManager javaFxSettingsManager;
    private RepositoryManager repositoryManager;
    private ObservableList<SettingsSidebarItem> settingsItems;

    public SettingsView(ThemeManager themeManager, String applicationName, String applicationVersion, String applicationGitRevision, String applicationBuildTimestamp, Opener opener, SettingsManager settingsManager, RepositoryLocationLoader repositoryLocationLoader, JavaFxSettingsManager javaFxSettingsManager, RepositoryManager repositoryManager) {
        super((String)Localisation.tr((Object)"Settings"), themeManager);
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.applicationGitRevision = applicationGitRevision;
        this.applicationBuildTimestamp = applicationBuildTimestamp;
        this.opener = opener;
        this.settingsManager = settingsManager;
        this.repositoryLocationLoader = repositoryLocationLoader;
        this.javaFxSettingsManager = javaFxSettingsManager;
        this.repositoryManager = repositoryManager;
        this.initializeSettingsItems();
        this.sidebar = this.createSidebar();
        this.setSidebar((SettingsSidebar)this.sidebar);
    }

    private SettingsSidebar createSidebar() {
        SettingsSidebar sidebar = new SettingsSidebar(this.settingsItems);
        sidebar.selectedItemProperty().addListener(invalidation -> this.setCenter(((SettingsSidebarItem)sidebar.getSelectedItem()).getPanel()));
        return sidebar;
    }

    private void initializeSettingsItems() {
        ApplicationBuildInformation buildInformation = new ApplicationBuildInformation(this.applicationName, this.applicationVersion, this.applicationGitRevision, this.applicationBuildTimestamp);
        this.settingsItems = FXCollections.observableArrayList((Object[])new SettingsSidebarItem[]{new SettingsSidebarItem((Node)this.createUserInterfacePanel(), "userInterfaceButton", (String)Localisation.tr((Object)"User Interface")), new SettingsSidebarItem((Node)this.createRepositoriesPanel(), "repositoriesButton", (String)Localisation.tr((Object)"Repositories")), new SettingsSidebarItem((Node)new FileAssociationsPanel(), "settingsButton", (String)Localisation.tr((Object)"File Associations")), new SettingsSidebarItem((Node)new NetworkPanel(), "networkButton", (String)Localisation.tr((Object)"Network")), new SettingsSidebarItem((Node)new AboutPanel(this.opener, buildInformation), "aboutButton", (String)Localisation.tr((Object)"About"))});
    }

    private RepositoriesPanel createRepositoriesPanel() {
        ObservableList repositoryLocations = FXCollections.observableArrayList((Collection)this.settingsManager.loadRepositoryLocations());
        RepositoriesPanel repositoriesPanel = new RepositoriesPanel((ObservableList<RepositoryLocation<? extends Repository>>)repositoryLocations);
        repositoriesPanel.setOnRepositoryRefresh(() -> ((RepositoryManager)this.repositoryManager).triggerRepositoryChange());
        repositoriesPanel.setRepositoryLocationLoader(this.repositoryLocationLoader);
        repositoriesPanel.getRepositoryLocations().addListener(change -> {
            this.repositoryManager.updateRepositories((List)repositoryLocations);
            this.settingsManager.saveRepositories((List)repositoryLocations);
        });
        return repositoriesPanel;
    }

    private UserInterfacePanel createUserInterfacePanel() {
        UserInterfacePanel userInterfacePanel = new UserInterfacePanel((ObservableList<Theme>)FXCollections.observableArrayList((Object[])Themes.all()));
        userInterfacePanel.setScaling(this.javaFxSettingsManager.getScale());
        userInterfacePanel.setSelectedTheme(Themes.fromShortName(this.javaFxSettingsManager.getTheme()).orElse(Themes.STANDARD));
        userInterfacePanel.setAdvancedMode(this.javaFxSettingsManager.isAdvancedMode());
        userInterfacePanel.setShowScriptSource(this.javaFxSettingsManager.isViewScriptSource());
        userInterfacePanel.setOnRestoreSettings(this.javaFxSettingsManager::restoreDefault);
        userInterfacePanel.scalingProperty().addListener(invalidation -> {
            double scaling = userInterfacePanel.getScaling();
            this.pause.setOnFinished(event -> {
                this.getTabPane().getScene().getRoot().setStyle(String.format("-fx-font-size: %.2fpt;", scaling));
                this.javaFxSettingsManager.setScale(userInterfacePanel.getScaling());
                this.javaFxSettingsManager.save();
            });
            this.pause.playFromStart();
        });
        userInterfacePanel.selectedThemeProperty().addListener(invalidation -> {
            Theme selectedTheme = userInterfacePanel.getSelectedTheme();
            this.themeManager.setCurrentTheme(selectedTheme);
            this.javaFxSettingsManager.setTheme(selectedTheme.getShortName());
            this.javaFxSettingsManager.save();
        });
        userInterfacePanel.advancedModeProperty().addListener(invalidation -> {
            boolean advancedMode = userInterfacePanel.isAdvancedMode();
            this.javaFxSettingsManager.setAdvancedMode(advancedMode);
            this.javaFxSettingsManager.save();
        });
        userInterfacePanel.showScriptSourceProperty().addListener(invalidation -> {
            boolean showScriptSource = userInterfacePanel.isShowScriptSource();
            this.javaFxSettingsManager.setViewScriptSource(showScriptSource);
            this.javaFxSettingsManager.save();
        });
        return userInterfacePanel;
    }
}

