/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.library;

import org.phoenicis.configuration.PhoenicisGlobalConfiguration;
import org.phoenicis.javafx.components.library.control.LibraryFeaturePanel;
import org.phoenicis.javafx.controller.library.console.ConsoleController;
import org.phoenicis.javafx.settings.JavaFxSettingsConfiguration;
import org.phoenicis.javafx.views.ViewsConfiguration;
import org.phoenicis.javafx.views.mainwindow.console.ConsoleTabFactory;
import org.phoenicis.javafx.views.mainwindow.library.LibraryFilter;
import org.phoenicis.library.LibraryConfiguration;
import org.phoenicis.scripts.ScriptsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ViewsConfigurationLibrary {
    @Value(value="${application.name}")
    private String applicationName;
    @Value(value="${application.user.containers}")
    private String containersPath;
    @Autowired
    private LibraryConfiguration libraryConfiguration;
    @Autowired
    private ScriptsConfiguration scriptsConfiguration;
    @Autowired
    private PhoenicisGlobalConfiguration phoenicisGlobalConfiguration;
    @Autowired
    private JavaFxSettingsConfiguration javaFxSettingsConfiguration;
    @Autowired
    private ViewsConfiguration viewsConfiguration;

    @Bean
    public LibraryFeaturePanel viewLibrary() {
        LibraryFeaturePanel libraryFeaturePanel = new LibraryFeaturePanel();
        libraryFeaturePanel.setApplicationName(this.applicationName);
        libraryFeaturePanel.setContainersPath(this.containersPath);
        libraryFeaturePanel.setScriptInterpreter(this.scriptsConfiguration.scriptInterpreter());
        libraryFeaturePanel.setObjectMapper(this.phoenicisGlobalConfiguration.objectMapper());
        libraryFeaturePanel.setJavaFxSettingsManager(this.javaFxSettingsConfiguration.javaFxSettingsManager());
        libraryFeaturePanel.setConsoleController(this.consoleController());
        libraryFeaturePanel.setShortcutRunner(this.libraryConfiguration.shortcutRunner());
        libraryFeaturePanel.setShortcutManager(this.libraryConfiguration.shortcutManager());
        libraryFeaturePanel.setFilter(new LibraryFilter());
        return libraryFeaturePanel;
    }

    @Bean
    public ConsoleController consoleController() {
        return new ConsoleController(this.viewsConfiguration.consoleTabFactory(), this.scriptsConfiguration.scriptInterpreter());
    }

    @Bean
    public ConsoleTabFactory consoleTabFactory() {
        return new ConsoleTabFactory();
    }
}

