/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.library;

import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.phoenicis.library.dto.ShortcutCategoryDTO;
import org.phoenicis.library.dto.ShortcutDTO;

public class LibraryFilter {
    private final StringProperty searchTerm = new SimpleStringProperty("");
    private final ObjectProperty<ShortcutCategoryDTO> selectedShortcutCategory = new SimpleObjectProperty();

    public boolean filter(ShortcutCategoryDTO shortcutCategory) {
        return Optional.ofNullable(this.searchTerm.getValueSafe()).map(searchTerm -> shortcutCategory.getShortcuts().stream().anyMatch(this::filter)).orElse(true);
    }

    public boolean filter(ShortcutDTO shortcut) {
        boolean searchTermConstraint = Optional.ofNullable(this.searchTerm.getValueSafe()).map(searchTerm -> shortcut.getInfo().getName().toLowerCase().contains(searchTerm.toLowerCase())).orElse(true);
        boolean selectedShortcutCategoryConstraint = Optional.ofNullable((ShortcutCategoryDTO)this.selectedShortcutCategory.getValue()).map(selectedShortcutCategory -> selectedShortcutCategory.getShortcuts().contains(shortcut)).orElse(true);
        return searchTermConstraint && selectedShortcutCategoryConstraint;
    }

    public StringProperty searchTermProperty() {
        return this.searchTerm;
    }

    public ObjectProperty<ShortcutCategoryDTO> selectedShortcutCategoryProperty() {
        return this.selectedShortcutCategory;
    }
}

