/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.installations.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.Comparator;
import javafx.scene.Node;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.phoenicis.scripts.ui.InstallationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
public class InstallationDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallationDTO.class);
    private final String id;
    private final String name;
    private final InstallationType category;
    private final String description;
    private final URI miniature;
    private final Node node;
    private static final String ID_REGEX = "^[a-zA-Z0-9_.]+$";
    private static final String INVALID_ID_CHARS_REGEX = "[^a-zA-Z0-9_.]";

    private InstallationDTO(Builder builder) {
        if (builder.id != null) {
            if (builder.id.matches(ID_REGEX)) {
                this.id = builder.id;
            } else {
                LOGGER.warn(String.format("Installation ID (%s) contains invalid characters, will remove them.", builder.id));
                this.id = builder.id.replaceAll(INVALID_ID_CHARS_REGEX, "");
            }
        } else {
            this.id = null;
        }
        this.name = builder.name;
        this.category = builder.category;
        this.description = builder.description;
        this.miniature = builder.miniature;
        this.node = builder.node;
    }

    public String getId() {
        return this.id;
    }

    public URI getMiniature() {
        return this.miniature;
    }

    public String getName() {
        return this.name;
    }

    public InstallationType getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public Node getNode() {
        return this.node;
    }

    public static Comparator<InstallationDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallationDTO that = (InstallationDTO)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append((Object)this.category, (Object)that.category).append((Object)this.description, (Object)that.description).append((Object)this.miniature, (Object)that.miniature).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.name).append((Object)this.category).append((Object)this.description).append((Object)this.miniature).append((Object)this.node).toHashCode();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    public static class Builder {
        private String id;
        private String name;
        private InstallationType category;
        private String description;
        private URI miniature;
        private Node node;

        public Builder() {
        }

        public Builder(InstallationDTO installationDTO) {
            this.id = installationDTO.id;
            this.name = installationDTO.name;
            this.category = installationDTO.category;
            this.description = installationDTO.description;
            this.miniature = installationDTO.miniature;
            this.node = installationDTO.node;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCategory(InstallationType category) {
            this.category = category;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withMiniature(URI miniature) {
            this.miniature = miniature;
            return this;
        }

        public Builder withNode(Node node) {
            this.node = node;
            return this;
        }

        public InstallationDTO build() {
            return new InstallationDTO(this);
        }

        public String getName() {
            return this.name;
        }
    }
}

