/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.installations.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.phoenicis.configuration.localisation.Translatable;
import org.phoenicis.configuration.localisation.TranslatableBuilder;
import org.phoenicis.configuration.localisation.Translate;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@Translatable
public class InstallationCategoryDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstallationCategoryDTO.class);
    private final String id;
    private final String name;
    private final String description;
    private final List<InstallationDTO> installations;
    private URI icon;
    private static final String ID_REGEX = "^[a-zA-Z0-9_.]+$";
    private static final String INVALID_ID_CHARS_REGEX = "[^a-zA-Z0-9_.]";

    private InstallationCategoryDTO(Builder builder) {
        if (builder.id != null) {
            if (builder.id.matches(ID_REGEX)) {
                this.id = builder.id;
            } else {
                LOGGER.warn(String.format("Installation category ID (%s) contains invalid characters, will remove them.", builder.id));
                this.id = builder.id.replaceAll(INVALID_ID_CHARS_REGEX, "");
            }
        } else {
            this.id = null;
        }
        this.name = builder.name == null ? builder.id : builder.name;
        this.description = builder.description;
        this.installations = Collections.unmodifiableList(builder.installations);
        this.icon = builder.icon;
    }

    public String getId() {
        return this.id;
    }

    @Translate
    public String getName() {
        return this.name;
    }

    @Translate
    public String getDescription() {
        return this.description;
    }

    public List<InstallationDTO> getInstallations() {
        return this.installations;
    }

    public URI getIcon() {
        return this.icon;
    }

    public static Comparator<InstallationCategoryDTO> nameComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallationCategoryDTO that = (InstallationCategoryDTO)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append((Object)this.description, (Object)that.description).append(this.installations, that.installations).append((Object)this.icon, (Object)that.icon).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.name).append((Object)this.description).append(this.installations).append((Object)this.icon).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.name).toString();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @TranslatableBuilder
    public static class Builder {
        private String id;
        private String name;
        private String description;
        private List<InstallationDTO> installations = new ArrayList<InstallationDTO>();
        private URI icon;

        public Builder() {
        }

        public Builder(InstallationCategoryDTO categoryDTO) {
            this.withId(categoryDTO.getId()).withName(categoryDTO.getName()).withDescription(categoryDTO.getDescription()).withInstallations(categoryDTO.getInstallations()).withIcon(categoryDTO.getIcon());
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withInstallations(List<InstallationDTO> installations) {
            this.installations = installations;
            return this;
        }

        public Builder withIcon(URI iconPath) {
            this.icon = iconPath;
            return this;
        }

        public InstallationCategoryDTO build() {
            return new InstallationCategoryDTO(this);
        }
    }
}

