/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.installations;

import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationCategoryDTO;
import org.phoenicis.javafx.views.mainwindow.installations.dto.InstallationDTO;

public class InstallationsFilter {
    private StringProperty searchTerm = new SimpleStringProperty("");
    private ObjectProperty<InstallationCategoryDTO> selectedInstallationCategory = new SimpleObjectProperty();

    public boolean filter(InstallationCategoryDTO installationCategory) {
        return Optional.ofNullable(this.searchTerm.getValueSafe()).map(searchTerm -> installationCategory.getInstallations().stream().anyMatch(this::filter)).orElse(true);
    }

    public boolean filter(InstallationDTO installation) {
        boolean searchTermConstraint = Optional.ofNullable(this.searchTerm.getValueSafe()).map(searchTerm -> installation.getName().toLowerCase().contains(searchTerm.toLowerCase())).orElse(true);
        boolean selectedInstallationCategoryConstraint = Optional.ofNullable((InstallationCategoryDTO)this.selectedInstallationCategory.getValue()).map(selectedShortcutCategory -> selectedShortcutCategory.getInstallations().contains(installation)).orElse(true);
        return searchTermConstraint && selectedInstallationCategoryConstraint;
    }

    public StringProperty searchTermProperty() {
        return this.searchTerm;
    }

    public ObjectProperty<InstallationCategoryDTO> selectedInstallationCategoryProperty() {
        return this.selectedInstallationCategory;
    }
}

