/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.engines;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.engines.Engine;
import org.phoenicis.engines.dto.EngineCategoryDTO;
import org.phoenicis.engines.dto.EngineDTO;
import org.phoenicis.engines.dto.EngineSubCategoryDTO;
import org.phoenicis.javafx.collections.ConcatenatedList;
import org.phoenicis.javafx.collections.MappedList;
import org.phoenicis.javafx.components.common.control.DetailsPanel;
import org.phoenicis.javafx.components.common.widgets.utils.ListWidgetType;
import org.phoenicis.javafx.components.engine.control.EngineInformationPanel;
import org.phoenicis.javafx.components.engine.control.EngineSidebar;
import org.phoenicis.javafx.components.engine.control.EngineSubCategoryPanel;
import org.phoenicis.javafx.settings.JavaFxSettingsManager;
import org.phoenicis.javafx.themes.ThemeManager;
import org.phoenicis.javafx.utils.StringBindings;
import org.phoenicis.javafx.views.mainwindow.engines.EnginesFilter;
import org.phoenicis.javafx.views.mainwindow.ui.MainWindowView;

public class EnginesView
extends MainWindowView<EngineSidebar> {
    private final EnginesFilter filter;
    private final JavaFxSettingsManager javaFxSettingsManager;
    private final Map<String, Engine> engines;
    private final ObservableList<EngineCategoryDTO> engineCategories;
    private final ObservableList<Tab> engineSubCategoryTabs;
    private final DetailsPanel engineDetailsPanel;
    private final ObjectProperty<ListWidgetType> selectedListWidget;
    private final ObjectProperty<EngineDTO> engineDTO;
    private final ObjectProperty<Engine> engine;
    private TabPane availableEngines;
    private Consumer<EngineDTO> setOnInstallEngine;
    private Consumer<EngineDTO> setOnDeleteEngine;
    private Consumer<EngineCategoryDTO> onSelectEngineCategory;
    private String enginesPath;

    public EnginesView(ThemeManager themeManager, String enginesPath, JavaFxSettingsManager javaFxSettingsManager) {
        super((String)Localisation.tr((Object)"Engines"), themeManager);
        this.enginesPath = enginesPath;
        this.javaFxSettingsManager = javaFxSettingsManager;
        this.filter = new EnginesFilter(enginesPath);
        this.engines = new HashMap<String, Engine>();
        this.engineCategories = FXCollections.observableArrayList();
        this.selectedListWidget = new SimpleObjectProperty();
        this.engineDTO = new SimpleObjectProperty();
        this.engine = new SimpleObjectProperty();
        this.filter.selectedEngineCategoryProperty().addListener(invalidation -> {
            EngineCategoryDTO engineCategory = this.filter.getSelectedEngineCategory();
            if (engineCategory != null) {
                Optional.ofNullable(this.onSelectEngineCategory).ifPresent(listener -> listener.accept(engineCategory));
            }
        });
        EngineSidebar engineSidebar = this.createEngineSidebar();
        this.setSidebar(engineSidebar);
        this.engineDetailsPanel = this.createEngineDetailsPanel();
        this.engineSubCategoryTabs = this.createEngineSubCategoryTabs(engineSidebar);
        this.availableEngines = this.createEngineVersion();
    }

    public void setOnSelectEngineCategory(Consumer<EngineCategoryDTO> engineCategory) {
        this.onSelectEngineCategory = engineCategory;
    }

    public void setOnInstallEngine(Consumer<EngineDTO> onInstallEngine) {
        this.setOnInstallEngine = onInstallEngine;
    }

    public void setOnDeleteEngine(Consumer<EngineDTO> onDeleteEngine) {
        this.setOnDeleteEngine = onDeleteEngine;
    }

    private TabPane createEngineVersion() {
        TabPane availableEngines = new TabPane();
        availableEngines.getStyleClass().add((Object)"rightPane");
        availableEngines.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Bindings.bindContent((List)availableEngines.getTabs(), this.engineSubCategoryTabs);
        return availableEngines;
    }

    private ObservableList<Tab> createEngineSubCategoryTabs(EngineSidebar sidebar) {
        MappedList engineSubCategoryPanelGroups = new MappedList(this.engineCategories, engineCategory -> engineCategory.getSubCategories().stream().map(engineSubCategory -> {
            EngineSubCategoryPanel engineSubCategoryPanel = new EngineSubCategoryPanel();
            engineSubCategoryPanel.setEngineCategory((EngineCategoryDTO)engineCategory);
            engineSubCategoryPanel.setEngineSubCategory((EngineSubCategoryDTO)engineSubCategory);
            engineSubCategoryPanel.setEnginesPath(this.enginesPath);
            engineSubCategoryPanel.setFilter(this.filter);
            engineSubCategoryPanel.setEngine(this.engines.get(engineCategory.getName().toLowerCase()));
            engineSubCategoryPanel.selectedListWidgetProperty().bind(sidebar.selectedListWidgetProperty());
            engineSubCategoryPanel.setOnEngineSelect(this::showEngineDetails);
            return engineSubCategoryPanel;
        }).collect(Collectors.toList()));
        ConcatenatedList engineSubCategoryPanels = ConcatenatedList.create((ObservableList)engineSubCategoryPanelGroups);
        FilteredList filteredEngineSubCategoryPanels = engineSubCategoryPanels.sorted(Comparator.comparing(engineSubCategoryPanel -> engineSubCategoryPanel.getEngineSubCategory().getName())).filtered(this.filter::filter);
        filteredEngineSubCategoryPanels.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.filter::filter, (Observable[])new Observable[]{this.filter.searchTermProperty(), this.filter.showInstalledProperty(), this.filter.showNotInstalledProperty()}));
        return new MappedList((ObservableList)filteredEngineSubCategoryPanels, engineSubCategoryPanel -> new Tab(engineSubCategoryPanel.getEngineSubCategory().getDescription(), (Node)engineSubCategoryPanel));
    }

    private EngineSidebar createEngineSidebar() {
        EngineSidebar sidebar = new EngineSidebar(this.filter, this.engineCategories, this.selectedListWidget);
        sidebar.setJavaFxSettingsManager(this.javaFxSettingsManager);
        sidebar.setSelectedListWidget(this.javaFxSettingsManager.getEnginesListType());
        sidebar.selectedListWidgetProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.javaFxSettingsManager.setEnginesListType((ListWidgetType)((Object)newValue));
                this.javaFxSettingsManager.save();
            }
        });
        return sidebar;
    }

    public void populate(List<EngineCategoryDTO> engineCategoryDTOS, Map<String, Engine> newEngines) {
        this.engines.clear();
        this.engines.putAll(newEngines);
        Platform.runLater(() -> {
            this.engineCategories.setAll((Collection)engineCategoryDTOS);
            this.closeDetailsView();
            this.setCenter((Node)this.availableEngines);
        });
    }

    public void updateVersions(EngineCategoryDTO engineCategoryDTO, List<EngineSubCategoryDTO> versions) {
        Platform.runLater(() -> {
            EngineCategoryDTO newEngineCategoryDTO = new EngineCategoryDTO.Builder(engineCategoryDTO).withSubCategories(versions).build();
            this.engineCategories.remove((Object)engineCategoryDTO);
            this.engineCategories.add((Object)newEngineCategoryDTO);
        });
    }

    private DetailsPanel createEngineDetailsPanel() {
        EngineInformationPanel engineInformationPanel = new EngineInformationPanel();
        engineInformationPanel.engineDTOProperty().bind(this.engineDTO);
        engineInformationPanel.engineProperty().bind(this.engine);
        engineInformationPanel.setOnEngineInstall(this::installEngine);
        engineInformationPanel.setOnEngineDelete(this::deleteEngine);
        DetailsPanel detailsPanel = new DetailsPanel();
        detailsPanel.titleProperty().bind((ObservableValue)StringBindings.map(this.engineDTO, engine -> engine.getCategory() + " " + engine.getSubCategory()));
        detailsPanel.setContent((Node)engineInformationPanel);
        detailsPanel.setOnClose(this::closeDetailsView);
        detailsPanel.prefWidthProperty().bind((ObservableValue)this.content.widthProperty().divide(3));
        return detailsPanel;
    }

    private void showEngineDetails(EngineDTO engineDTO, Engine engine) {
        this.engineDTO.setValue((Object)engineDTO);
        this.engine.setValue((Object)engine);
        this.showDetailsView((Node)this.engineDetailsPanel);
    }

    private void installEngine(EngineDTO engineDTO) {
        this.setOnInstallEngine.accept(engineDTO);
    }

    private void deleteEngine(EngineDTO engineDTO) {
        this.setOnDeleteEngine.accept(engineDTO);
    }
}

