/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.engines;

import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.phoenicis.engines.dto.EngineCategoryDTO;
import org.phoenicis.engines.dto.EngineSubCategoryDTO;
import org.phoenicis.engines.dto.EngineVersionDTO;
import org.phoenicis.javafx.components.engine.control.EngineSubCategoryPanel;

public class EnginesFilter {
    private String enginesPath;
    private StringProperty searchTerm;
    private ObjectProperty<EngineCategoryDTO> selectedEngineCategory;
    private BooleanProperty showInstalled;
    private BooleanProperty showNotInstalled;

    public EnginesFilter(String enginesPath) {
        this.enginesPath = enginesPath;
        this.searchTerm = new SimpleStringProperty("");
        this.selectedEngineCategory = new SimpleObjectProperty();
        this.showInstalled = new SimpleBooleanProperty();
        this.showNotInstalled = new SimpleBooleanProperty();
    }

    public EngineCategoryDTO getSelectedEngineCategory() {
        return (EngineCategoryDTO)this.selectedEngineCategory.get();
    }

    public StringProperty searchTermProperty() {
        return this.searchTerm;
    }

    public ObjectProperty<EngineCategoryDTO> selectedEngineCategoryProperty() {
        return this.selectedEngineCategory;
    }

    public BooleanProperty showInstalledProperty() {
        return this.showInstalled;
    }

    public BooleanProperty showNotInstalledProperty() {
        return this.showNotInstalled;
    }

    private boolean isInstalled(EngineCategoryDTO engineCategory, EngineSubCategoryDTO engineSubCategory, EngineVersionDTO engineVersionDTO) {
        return Paths.get(this.enginesPath, engineCategory.getName().toLowerCase(), engineSubCategory.getName(), engineVersionDTO.getVersion()).toFile().exists();
    }

    public Predicate<EngineVersionDTO> createFilter(EngineCategoryDTO engineCategory, EngineSubCategoryDTO engineSubCategory) {
        return engineVersion -> {
            boolean containsSearchTerm = Optional.ofNullable(this.searchTerm.getValueSafe()).map(searchTerm -> engineVersion.getVersion().toLowerCase().contains(searchTerm.toLowerCase())).orElse(true);
            boolean fulfillsShowInstalled = this.showInstalled.getValue() != false && this.isInstalled(engineCategory, engineSubCategory, (EngineVersionDTO)engineVersion);
            boolean fulfillsShowNotInstalled = this.showNotInstalled.getValue() != false && !this.isInstalled(engineCategory, engineSubCategory, (EngineVersionDTO)engineVersion);
            return containsSearchTerm && (fulfillsShowInstalled || fulfillsShowNotInstalled);
        };
    }

    public boolean filter(EngineCategoryDTO engineCategory) {
        return Optional.ofNullable(this.searchTerm.getValueSafe()).map(searchTerm -> engineCategory.getSubCategories().stream().anyMatch(engineSubCategory -> engineSubCategory.getPackages().stream().anyMatch(version -> version.getVersion().toLowerCase().contains(searchTerm.toLowerCase())))).orElse(true);
    }

    public boolean filter(EngineSubCategoryPanel engineSubCategoryPanel) {
        boolean tabNotEmpty = engineSubCategoryPanel.notEmpty(this);
        boolean selectedEngineCategoryConstraint = Optional.ofNullable((EngineCategoryDTO)this.selectedEngineCategory.getValue()).map(selectedEngineCategory -> selectedEngineCategory.equals((Object)engineSubCategoryPanel.getEngineCategory())).orElse(true);
        return tabNotEmpty && selectedEngineCategoryConstraint;
    }
}

