/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.containers;

import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.phoenicis.containers.dto.ContainerCategoryDTO;
import org.phoenicis.containers.dto.ContainerDTO;

public class ContainersFilter {
    private StringProperty searchTerm = new SimpleStringProperty();
    private ObjectProperty<ContainerCategoryDTO> selectedContainerCategory = new SimpleObjectProperty();

    public boolean filter(ContainerCategoryDTO containerCategory) {
        return Optional.ofNullable(this.searchTerm.getValueSafe()).map(searchTerm -> containerCategory.getContainers().stream().anyMatch(this::filter)).orElse(true);
    }

    public boolean filter(ContainerDTO installation) {
        boolean searchTermConstraint = Optional.ofNullable(this.searchTerm.getValueSafe()).map(searchTerm -> installation.getName().toLowerCase().contains(searchTerm.toLowerCase())).orElse(true);
        boolean selectedContainerCategoryConstraint = Optional.ofNullable((ContainerCategoryDTO)this.selectedContainerCategory.getValue()).map(selectedContainerCategory -> selectedContainerCategory.getContainers().contains(installation)).orElse(true);
        return searchTermConstraint && selectedContainerCategoryConstraint;
    }

    public StringProperty searchTermProperty() {
        return this.searchTerm;
    }

    public ObjectProperty<ContainerCategoryDTO> selectedContainerCategoryProperty() {
        return this.selectedContainerCategory;
    }
}

