/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.console;

import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.phoenicis.configuration.localisation.Localisation;
import org.phoenicis.javafx.views.mainwindow.console.CommandHistory;
import org.phoenicis.javafx.views.mainwindow.console.ConsoleTextType;

public class ConsoleTab
extends Tab {
    private final CommandHistory commandHistory = new CommandHistory();
    private final TextField command = new TextField();
    private final TextFlow console = new TextFlow();
    private final ScrollPane consolePane;
    private boolean forceScroll = false;
    private Consumer<String> onSendCommand = text -> {};

    public ConsoleTab() {
        BorderPane content = new BorderPane();
        this.setText((String)Localisation.tr((Object)"Console"));
        this.setContent((Node)content);
        this.command.getStyleClass().add((Object)"consoleCommandType");
        this.consolePane = new ScrollPane((Node)this.console);
        content.widthProperty().addListener((observable, oldValue, newValue) -> this.console.setPrefWidth(content.getWidth() * 0.94));
        content.getStyleClass().add((Object)"rightPane");
        this.consolePane.getStyleClass().add((Object)"console");
        this.consolePane.vvalueProperty().addListener((ov, oldValue, newValue) -> {
            if (this.forceScroll && (Double)newValue != 1.0) {
                this.consolePane.vvalueProperty().setValue((Number)1.0);
            }
        });
        content.setCenter((Node)this.consolePane);
        content.setBottom((Node)this.command);
        this.command.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.onSendCommand.accept(this.command.getText());
                this.commandHistory.add(new CommandHistory.Item(this.command.getText(), this.command.getCaretPosition()));
                this.clearCommand();
            }
        });
        this.consolePane.setOnMouseMoved(event -> {
            this.forceScroll = false;
        });
        this.command.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.UP) {
                CommandHistory.Item historyItem = this.commandHistory.up();
                this.command.setText(historyItem.getCommand());
                this.command.positionCaret(historyItem.getCursorPosition());
            } else if (event.getCode() == KeyCode.DOWN) {
                CommandHistory.Item historyItem = this.commandHistory.down();
                this.command.setText(historyItem.getCommand());
                this.command.positionCaret(historyItem.getCursorPosition());
            }
        });
        Platform.runLater(() -> ((TextField)this.command).requestFocus());
        this.command.setPromptText("> ");
    }

    public void setOnSendCommand(Consumer<String> onSendCommand) {
        this.onSendCommand = onSendCommand;
    }

    public void disableCommand() {
        this.command.setDisable(true);
    }

    public void enableCommand() {
        Platform.runLater(() -> {
            this.command.setDisable(false);
            this.command.requestFocus();
        });
    }

    public void clearCommand() {
        this.command.setText("");
    }

    public String getCommandValue() {
        return this.command.getText();
    }

    public void appendTextToConsole(String text) {
        this.appendTextToConsole(text, ConsoleTextType.DEFAULT);
    }

    public void appendTextToConsole(String text, ConsoleTextType textType) {
        Text commandText = new Text(text);
        commandText.setWrappingWidth(this.console.getWidth());
        commandText.getStyleClass().addAll((Object[])new String[]{"consoleText", textType.getCssName()});
        Platform.runLater(() -> {
            this.forceScroll = true;
            this.console.getChildren().add((Object)commandText);
            this.console.layout();
            this.consolePane.vvalueProperty().setValue((Number)1.0);
        });
    }
}

