/*
 * Decompiled with CFR 0.152.
 */
package org.phoenicis.javafx.views.mainwindow.console;

import java.util.ArrayList;
import java.util.List;

class CommandHistory {
    private final List<Item> history = new ArrayList<Item>();
    private int historyPosition = 0;

    CommandHistory() {
    }

    public void add(Item item) {
        this.history.add(item);
        this.historyPosition = this.history.size();
    }

    Item up() {
        if (this.historyPosition > 0) {
            --this.historyPosition;
        }
        return this.current();
    }

    Item down() {
        this.historyPosition = this.historyPosition < this.history.size() ? this.historyPosition + 1 : this.history.size();
        return this.current();
    }

    private Item current() {
        if (!this.history.isEmpty() && this.historyPosition < this.history.size()) {
            return this.history.get(this.historyPosition);
        }
        return Item.EMPTY;
    }

    static final class Item {
        static final Item EMPTY = new Item("", 0);
        private final String command;
        private final int cursorPosition;

        Item(String command, int cursorPosition) {
            this.command = command;
            this.cursorPosition = cursorPosition;
        }

        String getCommand() {
            return this.command;
        }

        int getCursorPosition() {
            return this.cursorPosition;
        }
    }
}

